<?php
/**
 * @package WordPress
 * @subpackage proradio
 * @subpackage kirki
 * @version 1.0.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}



/**
 * Corner radius
 * ============================================================ */

Kirki::add_field( 'proradio_config', [
	'type'        => 'slider',
	'settings'    => 'items_pad_mob',
	'label'       => esc_html__( 'Post items content padding', 'proradio' ).' '.esc_html__( 'mobile', 'proradio' ),
	'description' => esc_html__( 'Affects the content padding of every card element', "proradio" ),
	'section'     => 'proradio_post_items_section',
	'transport'   => 'auto',
	'choices'     => [
		'min'  => 0,
		'max'  => 70,
		'step' => 1,
	],
	'output'    => array(
		array(
			'element'       => '.proradio-post__content',
			'property'      => 'padding',
			'value_pattern' => esc_attr( ' $px;' ),
			'media_query' => '@media (max-width: 1119px)'
		),


	),
] );



Kirki::add_field( 'proradio_config', [
	'type'        => 'slider',
	'settings'    => 'items_pad_des',
	'label'       => esc_html__( 'Post items content padding', 'proradio' ).' '.esc_html__( 'desktop', 'proradio' ),
	'description' => esc_html__( 'Affects the content padding of every card element', "proradio" ),
	'section'     => 'proradio_post_items_section',
	'transport'   => 'auto',
	'choices'     => [
		'min'  => 0,
		'max'  => 70,
		'step' => 1,
	],
	'output'    => array(
		array(
			'element'       => '.proradio-post__content',
			'property'      => 'padding',
			'value_pattern' => esc_attr( ' $px;' ),
			'media_query' => '@media (min-width: 1200px)'
		),


	),
] );




Kirki::add_field( 'proradio_config', [
	'type'        => 'slider',
	'settings'    => 'items_rad',
	'label'       => esc_html__( 'Post items corner radius', 'proradio' ),
	'description' => esc_html__( 'Affect border radius of every card element in the site for coherence', "proradio" ),
	'section'     => 'proradio_post_items_section',
	'default'     => 0,
	'transport'   => 'auto',
	'choices'     => [
		'min'  => 0,
		'max'  => 12,
		'step' => 1,
	],
	'output'    => array(
		array(
			'element'       => '.proradio-chart-tracklist .proradio-chart-track, .proradio-post, .proradio-bgimg, .proradio-post__header, .proradio-post__header .proradio-bgimg, .proradio-cards__content , .proradio-pricingtable__content, .proradio-pricingtable__pc::before, .proradio-card, .proradio-scard, .proradio-authorbox, .proradio-cat-card,  .blocks-gallery-item figure',
			'property'      => 'border-radius',
			'value_pattern' => esc_attr( ' $px;' ),
		),
		array(
			'element'       => '.proradio-videogalleries__item',
			'property'      => 'border-radius',
			'value_pattern' => esc_attr( ' $px;' ),
		),
		//bbpress
		array(
			'element' 		=> '.bbp-body, .bbp-form, img.avatar, .bbp-template-notice, #proradio-body fieldset.bbp-form legend, .proradio-bbpress--header, .bbp-forums, #bbp-user-wrapper, #proradio-body.woocommerce .proradio-master .woocommerce-tabs .panel, .woocommerce-product-gallery, #proradio-body.woocommerce .proradio-master .woocommerce-tabs ul.tabs.wc-tabs',
			'property'      => 'border-radius',
			'value_pattern' => esc_attr( ' $px;' ),
		)


	),
] );


Kirki::add_field( 'proradio_config', [
	'type'        => 'slider',
	'settings'    => 'items_shad',
	'label'       => esc_html__( 'Shadow', 'proradio' ),
	'section'     => 'proradio_post_items_section',
	'default'     => 0.5,
	'transport'   => 'auto',
	'choices'     => [
		'min'  => 0,
		'max'  => 1,
		'step' => 0.01,
	],
	'output'    => array(
		array(
			'element'       => '.proradio-post, #proradio-body a.proradio-cat-card, .proradio-videogalleries__item, .proradio-arrow',
			'property'      => 'box-shadow',
			'value_pattern' => '0 0 6px 0px rgba(0, 0, 0, $);',
		),
		//bbpress
		array(
			'element' 		=> '.bbp-body, .bbp-form, .proradio-bbpress--header, .bbp-forums, #bbp-user-wrapper',
			'property'      => 'box-shadow',
			'value_pattern' => '0 0 6px 0px rgba(0, 0, 0, $);',
		)
	),
] );





Kirki::add_field( 'proradio_config', [
	'type'        => 'slider',
	'settings'    => 'items_bg_grad',
	'label'       => esc_html__( 'Background gradient for texts', 'proradio' ),
	'description' => esc_html__( 'Set the opacity of the black background on top of the items to improve legibility', "proradio" ),
	'section'     => 'proradio_post_items_section',
	'default'     => 0.7,
	'transport'   => 'auto',
	'choices'     => [
		'min'  => 0,
		'max'  => 1,
		'step' => 0.01,
	],
	'output'    => array(
		array(
			'element'       => '.proradio-post__card .proradio-post__headercont, .proradio-post__hero .proradio-post__headercont, #proradio-body .proradio-master .proradio-slider__c',
			'property'      => 'background',
			'value_pattern' => esc_attr( 'linear-gradient(to bottom, rgba(0, 0, 0, 0) 0%, rgba(0, 0, 0, 0) 40%, rgba(0, 0, 0, $) 65%, rgba(0, 0, 0, $) 100%);' ),
		),
	),
] );

Kirki::add_field( 'proradio_config', [
	'type'        => 'slider',
	'settings'    => 'items_meta_fontsize',
	'label'       => esc_html__( 'Post meta information font size', 'proradio' ),
	'description' => esc_html__( 'Change size for small text as date, author and other secondary information', "proradio" ),
	'section'     => 'proradio_post_items_section',
	'transport'   => 'auto',
	'choices'     => [
		'min'  => 8,
		'max'  => 20,
		'step' => 1,
	],
	'output'    => array(
		array(
			'element'       => '.proradio-post .proradio-meta, .proradio-itemmetas',
			'property'      => 'font-size',
			'value_pattern' => esc_attr( ' $px' ),
		),
	),
] );

Kirki::add_field( 'proradio_config', [
	'type'        => 'slider',
	'settings'    => 'cats_fontsize',
	'label'       => esc_html__( 'Categories font size', 'proradio' ),
	'section'     => 'proradio_post_items_section',
	'transport'   => 'auto',
	'choices'     => [
		'min'  => 8,
		'max'  => 20,
		'step' => 1,
	],
	'output'    => array(
		array(
			'element'       => '.proradio-cats a',
			'property'      => 'font-size',
			'value_pattern' => esc_attr( ' $px' ),
		),
	),
] );




/**
 * ======================================================
 *  Hover styling
 * ======================================================
 */




Kirki::add_field( 'proradio_config', array(
	'type'        => 'custom',
	'settings'    => 'sep_hover_styling',
	'label'       => '',
	'section'     => 'proradio_post_items_section',
	'default'     =>  '<h2 class="proradio-kirki-sectioncaption">'. esc_html__( 'Hover effects', "proradio" ).'</h2>',
) );


Kirki::add_field( 'proradio_config', [
	'type'        => 'slider',
	'settings'    => 'title_effect',
	'label'       => esc_html__( 'Title effect', 'proradio' ),
	'section'     => 'proradio_post_items_section',
	'default'     => 0.25,
	'transport'   => 'auto',
	'choices'     => [
		'min'  => 0,
		'max'  => 1.2,
		'step' => 0.05,
	],
	'output'    => array(
		array(
			'element'       => ':root, html',
			'property'      => '--proradio-title-fx-size',
			'value_pattern' => '0% $em',
		),
		array(
			'element'       => ':root, html',
			'property'      => '--proradio-title-fx-size-hov',
			'value_pattern' => '100% $em',
		),
	),
] );

Kirki::add_field( 'proradio_config', array(
	'type'        => 'color',
	'settings'    => 'title_effect_c1',
	'label'       => esc_html__( 'Title effect color left', "proradio" ),
	'section'     => 'proradio_post_items_section',
	'transport'   => 'auto',
	'priority'    => 10,
	'output'    => array(
		array(
			'element'       => ':root, html',
			'property'      => '--proradio-title-fx-col1',
		),
	),
));

Kirki::add_field( 'proradio_config', array(
	'type'        => 'color',
	'settings'    => 'title_effect_c2',
	'label'       => esc_html__( 'Title effect color right', "proradio" ),
	'section'     => 'proradio_post_items_section',
	'priority'    => 10,
	'transport'   => 'auto',
	'output'    => array(
		array(
			'element'       => ':root, html',
			'property'      => '--proradio-title-fx-col2',
		),
	),
));




Kirki::add_field( 'proradio_config', array(
	'type'      => 'toggle',
	'settings'  => 'items_duotone',
	'label'     => esc_attr__( 'Duotone hover effect', "proradio" ),
	'section'   => 'proradio_post_items_section',
	 'default'     => '1',
	'transport'   => 'refresh',
	'choices'     => [
		'1'  => esc_html__( 'Enable', 'proradio' ),
		'0' => esc_html__( 'Disable', 'proradio' ),
	],
	'output'    => array(
		array(
			'element'  => '.proradio-post .proradio-duotone::before, .proradio-post .proradio-duotone::after',
			'property' => 'display',
			'value_pattern' => 'none !important',
			'exclude'   => array( true, '1', 1 ),
		)
	)
) );

Kirki::add_field( 'proradio_config', array(
	'type'        => 'color',
	'settings'    => 'post_duotone_c1',
	'label'       => esc_html__( 'Hover duotone color light', "proradio" ),
	'description' => esc_html__( 'To disable set color white', "proradio" ),
	'section'     => 'proradio_post_items_section',
	'priority'    => 10,
	'output'    => array(
		array(
			'element'       => '.proradio-post .proradio-duotone::before',
			'property'      => 'background-color',
		),
	),
));
Kirki::add_field( 'proradio_config', array(
	'type'        => 'color',
	'settings'    => 'post_duotone_c2',
	'label'       => esc_html__( 'Hover duotone color dark', "proradio" ),
	'description' => esc_html__( 'To disable set color black', "proradio" ),
	'section'     => 'proradio_post_items_section',
	'priority'    => 10,
	'output'    => array(
		array(
			'element'       => '.proradio-post .proradio-duotone::after',
			'property'      => 'background-color',
		),
	),
));




Kirki::add_field( 'proradio_config', array(
	'type'      => 'toggle',
	'settings'  => 'items_show_icon',
	'label'     => esc_attr__( 'Show icon', "proradio" ),
	'section'   => 'proradio_post_items_section',
	 'default'     => '1',
	'transport'   => 'refresh',
	'choices'     => [
		'1'  => esc_html__( 'Show', 'proradio' ),
		'0' => esc_html__( 'Hide', 'proradio' ),
	],
	'output'    => array(
		array(
			'element'  => '.proradio-post .proradio-actions',
			'property' => 'display',
			'value_pattern' => 'none',
			'exclude'   => array( true, '1', 1 ),
		)
	)
) );


Kirki::add_field( 'proradio_config', [
	'type'        => 'slider',
	'settings'    => 'items_hover_speed',
	'label'       => esc_html__( 'Animation time', 'proradio' ),
	'section'     => 'proradio_post_items_section',
	'default'     => 0.35,
	'transport'   => 'auto',
	'choices'     => [
		'min'  => 0,
		'max'  => 3,
		'step' => 0.05,
	],
	'output'    => array(
		array(
			'element'       => ':root, html',
			'property'      => '--proradio-hover-trtime',
			'value_pattern' => '$s',
		),
	),
] );

Kirki::add_field( 'proradio_config', array(
	'type'        => 'custom',
	'settings'    => 'sep_hover_styling_scale',
	'label'       => '',
	'section'     => 'proradio_post_items_section',
	'default'     =>  '<h2>'. esc_html__( 'Scale', "proradio" ).'</h2>',
) );

Kirki::add_field( 'proradio_config', [
	'type'        => 'slider',
	'settings'    => 'items_hover_scale_start',
	'label'       => esc_html__( 'Hover initial scale', 'proradio' ),
	'section'     => 'proradio_post_items_section',
	'default'     => 1,
	'transport'   => 'auto',
	'choices'     => [
		'min'  => 1.01,
		'max'  => 1.35,
		'step' => 0.01,
	],
	'output'    => array(
		array(
			'element'       => ':root, html',
			'property'      => '--proradio-hover-img-scale',
		),
	),
] );

Kirki::add_field( 'proradio_config', [
	'type'        => 'slider',
	'settings'    => 'items_hover_scale_end',
	'label'       => esc_html__( 'Hover final scale', 'proradio' ),
	'section'     => 'proradio_post_items_section',
	'default'     => 1,
	'transport'   => 'auto',
	'choices'     => [
		'min'  => 1.01,
		'max'  => 1.6,
		'step' => 0.01,
	],
	'output'    => array(
		array(
			'element'       => ':root, html',
			'property'      => '--proradio-hover-img-scale-hov',
		),
	),
] );



Kirki::add_field( 'proradio_config', array(
	'type'        => 'custom',
	'settings'    => 'sep_hover_styling_blur',
	'label'       => '',
	'section'     => 'proradio_post_items_section',
	'default'     =>  '<h2>'. esc_html__( 'Blur', "proradio" ).'</h2>',
) );

Kirki::add_field( 'proradio_config', [
	'type'        => 'slider',
	'settings'    => 'items_hover_blur_start',
	'label'       => esc_html__( 'Hover initial blur', 'proradio' ),
	'section'     => 'proradio_post_items_section',
	'default'     => 0,
	'transport'   => 'auto',
	'choices'     => [
		'min'  => 0,
		'max'  => 20,
		'step' => 1,
	],
	'output'    => array(
		array(
			'element'       => ':root, html',
			'property'      => '--proradio-hover-img-blur',
			'value_pattern' => 'blur($px)',
		),
	),
] );

Kirki::add_field( 'proradio_config', [
	'type'        => 'slider',
	'settings'    => 'items_hover_blur_end',
	'label'       => esc_html__( 'Hover final blur', 'proradio' ),
	'section'     => 'proradio_post_items_section',
	'default'     => 0,
	'transport'   => 'auto',
	'choices'     => [
		 'min'  => 0,
		'max'  => 20,
		'step' => 1,
	],
	'output'    => array(
		array(
			'element'       => ':root, html',
			'property'      => '--proradio-hover-img-blur-hov',
			'value_pattern' => 'blur($px)',
		),
	),
] );

Kirki::add_field( 'proradio_config', array(
	'type'        => 'custom',
	'settings'    => 'sep_hover_styling_bright',
	'label'       => '',
	'section'     => 'proradio_post_items_section',
	'default'     =>  '<h2>'. esc_html__( 'Brightness', "proradio" ).'</h2>',
) );

Kirki::add_field( 'proradio_config', [
	'type'        => 'slider',
	'settings'    => 'items_hover_brightness_start',
	'label'       => esc_html__( 'Hover initial brigtness', 'proradio' ),
	'section'     => 'proradio_post_items_section',
	'default'     => 1,
	'transport'   => 'auto',
	'choices'     => [
		'min'  => 0,
		'max'  => 2,
		'step' => 0.1,
	],
	'output'    => array(
		array(
			'element'       => ':root, html',
			'property'      => '--proradio-hover-img-brightness',
			'value_pattern' => 'brightness($)',
		),
	),
] );

Kirki::add_field( 'proradio_config', [
	'type'        => 'slider',
	'settings'    => 'items_hover_brightness_end',
	'label'       => esc_html__( 'Hover final brigtness', 'proradio' ),
	'section'     => 'proradio_post_items_section',
	'default'     => 1,
	'transport'   => 'auto',
	'choices'     => [
		'min'  => 0,
		'max'  => 2,
		'step' => 0.1,
	],
	'output'    => array(
		array(
			'element'       => ':root, html',
			'property'      => '--proradio-hover-img-brightness-hov',
			'value_pattern' => 'brightness($)',
		),
	),
] );





Kirki::add_field( 'proradio_config', array(
	'type'        => 'custom',
	'settings'    => 'sep_hover_styling_gray',
	'label'       => '',
	'section'     => 'proradio_post_items_section',
	'default'     =>  '<h2>'. esc_html__( 'Grayscale', "proradio" ).'</h2>',
) );

Kirki::add_field( 'proradio_config', [
	'type'        => 'slider',
	'settings'    => 'items_hover_grayscale_start',
	'label'       => esc_html__( 'Hover initial grayscale', 'proradio' ),
	'section'     => 'proradio_post_items_section',
	'default'     => 0,
	'transport'   => 'auto',
	'choices'     => [
		'min'  => 0,
		'max'  => 1,
		'step' => 0.1,
	],
	'output'    => array(
		array(
			'element'       => ':root, html',
			'property'      => '--proradio-hover-img-grayscale',
			'value_pattern' => 'grayscale($)',
		),
	),
] );

Kirki::add_field( 'proradio_config', [
	'type'        => 'slider',
	'settings'    => 'items_hover_grayscale_end',
	'label'       => esc_html__( 'Hover final grayscale', 'proradio' ),
	'section'     => 'proradio_post_items_section',
	'default'     => 0,
	'transport'   => 'auto',
	'choices'     => [
		'min'  => 0,
		'max'  => 1,
		'step' => 0.1,
	],
	'output'    => array(
		array(
			'element'       => ':root, html',
			'property'      => '--proradio-hover-img-grayscale-hov',
			'value_pattern' => 'grayscale($)',
		),
	),
] );









