<?php
/**
 * @package WordPress
 * @subpackage proradio
 * @subpackage kirki
 * @version 1.0.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

/**
 * ======================================================
 *	Styling
 * ======================================================
 */
Kirki::add_field( 'proradio_config', array(
    'type'        => 'custom',
    'settings'    => 'sep_buttons_styling',
    'label'       => '',
    'section'     => 'proradio_buttons_section',
    'default'     =>  '<h2 class="proradio-kirki-sectioncaption">'. esc_html__( 'Style', "proradio" ).'</h2>',
) );

/**
 * Buttons
 * ============================================================ */
Kirki::add_field( 'proradio_config', [
	'type'        => 'slider',
	'settings'    => 'buttons_radius',
	'label'       => esc_html__( 'Buttons corner radius', 'proradio' ),
	'description' => esc_html__( 'Affect border radius of every button from this theme', "proradio" ),
	'section'     => 'proradio_buttons_section',
	'default'     => 3,
	'transport'   => 'auto',
	'choices'     => [
		'min'  => 0,
		'max'  => 50,
		'step' => 1,
	],
	'output'    => array(
		array(
			'element'       => '.proradio-arrow, .proradio-countdown__i, .proradio-slider__ab, .proradio-btn, .proradio-p-catz a, input[type="submit"],  .proradio-tags a, .ttg-btn-share,  .woocommerce a.button,#proradio-body.woocommerce #proradio-master .button,#proradio-body.woocommerce #proradio-master .proradio-woocommerce-content a.button,#proradio-body.woocommerce #proradio-master .proradio-woocommerce-content a.button,  a.button, .proradio-schedule .proradio-tabs__menu, .proradio-wp-pagination .page-numbers > span.proradio-btn',
			'property'      => 'border-radius',
			'value_pattern' => esc_attr( ' $px;' ),
		),
		array(
			'element'       => '.woocommerce #respond input#submit,.woocommerce a.button,.woocommerce button.button,.woocommerce input.button, #proradio-body.woocommerce .proradio-master .button, #proradio-body.woocommerce #proradio-master .woocommerce form .select2-container--default .select2-selection--single, .proradio-actions .proradio-a0::after, button.woocommerce-button::after',
			'property'      => 'border-radius',
			'value_pattern' => esc_attr( ' $px !important;' ),
		),
		// bbpress
		array(
			'element'       => 'button',
			'property'      => 'border-radius',
			'value_pattern' => esc_attr( ' $px !important;' ),
		),
		array(
			'element'       => '.qtmplayer__volume.proradio-btn.proradio-btn__r .qtmplayer__vcontainer, #proradio-body #proradio-master form input[type="submit"], #proradio-body #proradio-master form button, .proradio-comment__rlink a, .proradio-comment__cancelreply',
			'property'      => 'border-radius',
			'value_pattern' => esc_attr( ' $px;' ),
		),
		array(
			'element'       => '.proradio-tabs__menu li:first-child a',
			'property'      => 'border-radius',
			'value_pattern' => esc_attr( ' $px 0 0 $px' ),
			'media_query' => '@media (min-width: 1200px)'
		),
		array(
			'element'       => '.proradio-tabs__menu li:last-child a',
			'property'      => 'border-radius',
			'value_pattern' => esc_attr( ' 0 $px $px 0' ),
			'media_query' => '@media (min-width: 1200px)'
		),
		
		array (
			'element' => '.qtmplayer-donutcontainer.proradio-a0, .qtmplayer-donutcontainer.proradio-a0::after',
			'property'      => 'border-radius',
			'value_pattern' => esc_attr( '50%' ),
		),

		array(
			'element'       => 'button:not(.owl-dot):not(.proradio-btn__txt):not(.owl-dot):not(.owl-prev):not(.owl-next):not([aria-controls]):hover::after,
			button:not(.owl-dot):not(.proradio-btn__txt):not(.owl-dot):not(.owl-prev):not(.owl-next):not([aria-controls])::after',
			'property'      => 'border-radius',
			'value_pattern' => esc_attr( ' $px !important;' ),
			'media_query' => '@media (min-width: 1200px)'
		),



		
	),
] );

Kirki::add_field( 'proradio_config', [
	'type'        => 'slider',
	'settings'    => 'btn_fontsize_m',
	'label'       => esc_html__( 'Font size mobile', 'proradio' ),
	'description' => esc_html__( 'Default font size for buttons', "proradio" ),
	'section'     => 'proradio_buttons_section',
	'transport'   => 'auto',
	'choices'     => [
		'min'  => 8,
		'max'  => 20,
		'step' => 1,
	],
	'output'    => array(
		array(
			'element'       => '.proradio-btn',
			'property'      => 'font-size',
			'value_pattern' => esc_attr( ' $px' ),
			'media_query' => '@media (max-width: 1119px)'
		),
	)
] );
Kirki::add_field( 'proradio_config', [
	'type'        => 'slider',
	'settings'    => 'btn_fontsize',
	'label'       => esc_html__( 'Font size desktop', 'proradio' ),
	'description' => esc_html__( 'Default font size for buttons', "proradio" ),
	'section'     => 'proradio_buttons_section',
	'transport'   => 'auto',
	'choices'     => [
		'min'  => 8,
		'max'  => 26,
		'step' => 1,
	],
	'output'    => array(
		array(
			'element'       => '.proradio-btn',
			'property'      => 'font-size',
			'value_pattern' => esc_attr( ' $px' ),
			'media_query' => '@media (min-width: 1200px)'
		),
	)
] );

/**
 * ======================================================
 *	Flat colors
 * ======================================================
 */


Kirki::add_field( 'proradio_config', array(
    'type'        => 'custom',
    'settings'    => 'sep_buttons_colors',
    'label'       => '',
    'section'     => 'proradio_buttons_section',
    'default'     =>  '<h2 class="proradio-kirki-sectioncaption">'. esc_html__( 'Flat colors', "proradio" ).'</h2>',
) );

$selectors_list = array(
	'button:not(.owl-dot):not(.owl-prev):not(.owl-next):not(.proradio-btn__txt):not([aria-controls])',
	'input[type="submit"]', 
	'.proradio-entrycontent .wp-block-button .wp-block-button__link', 
	'.proradio-entrycontent .wp-block-button .wp-block-file__button', 
	'.proradio-btn.proradio-active',
	'.proradio-btn-primary', 
	'.woocommerce #respond input#submit',
	'.woocommerce a.button', 
	'.woocommerce button.button', 
	'.woocommerce input.button',
	'.woocommerce a.button',
	'#proradio-body.woocommerce #proradio-master .button',
	'#proradio-body.woocommerce .proradio-master #respond input#submit', 
	'#proradio-body.woocommerce .proradio-master .woocommerce #respond input#submit', 
	'#proradio-body.woocommerce .proradio-master .woocommerce a.button', 
	'#proradio-body.woocommerce .proradio-master .woocommerce button.button', 
	'#proradio-body.woocommerce .proradio-master .woocommerce input.button', 
	'#proradio-body.woocommerce #proradio-master .proradio-woocommerce-content a.button',
	'#proradio-body.woocommerce #proradio-master .proradio-woocommerce-content a.button',  
	'a.button'
);




Kirki::add_field( 'proradio_config', array(
	'type'        => 'color',
	'settings'    => 'proradio_btn_background',
	'label'       => esc_html__( 'Buttons background', "proradio" ),
	'section'     => 'proradio_buttons_section',
	'default'	  => '#ff0062',
	'transport'   => 'auto',
	// 'priority'    => 2,
	'choices'     => [
		'alpha' => true,
	],
	'output'    => array(
		array(
			'element'       => implode(',',$selectors_list),
			'property'      => 'background-color',
			 'suffix'   => ' !important',
		),
	),
));


Kirki::add_field( 'proradio_config', array(
	'type'        => 'color',
	'settings'    => 'proradio_btn_col',
	'label'       => esc_html__( 'Buttons color', "proradio" ),
	'section'     => 'proradio_buttons_section',
	'default'	  => '#ffffff',
	'transport'   => 'auto',
	// 'priority'    => 0,
	'choices'     => [
		'alpha' => false,
	],
	'output'    => array(
		array(
			'element'       => implode(',',$selectors_list),
			'property'      => 'color',
			 'suffix'   => ' !important',
		),
	),
));


// Hover classes array
$hover_selectors = array();
foreach( $selectors_list as $selector){
	$hover_selectors[] = $selector.':hover';
}
// Hover background
Kirki::add_field( 'proradio_config', array(
	'type'        => 'color',
	'settings'    => 'proradio_btn_background_h',
	'label'       => esc_html__( 'Buttons hover', "proradio" ),
	'section'     => 'proradio_buttons_section',
	'default'	  => '#be024a',
	'transport'   => 'auto',
	// 'priority'    => 0,
	'choices'     => [
		'alpha' => true,
	],
	'output'    => array(
		array(
			'element'       =>'.proradio-btn.proradio-btn-primary:hover::after, .proradio-btn.proradio-btn-primary:hover, .proradio-btn-primary::after ',
			'property'      => 'background-color',
			'media_query' => '@media (min-width: 100px)',
			 'suffix'   => ' !important',
		),
		array(
			'element'       => implode(',',$hover_selectors),
			'property'      => 'background-color',
			'media_query' => '@media (min-width: 100px)',
			 'suffix'   => ' !important',
		),

	),
));


/**
 * ======================================================
 *	Gradient
 * ======================================================
 */

Kirki::add_field( 'proradio_config', array(
    'type'        => 'custom',
    'settings'    => 'sep_buttons_grad',
    'label'       => '',
    'section'     => 'proradio_buttons_section',
    'default'     =>  '<h2 class="proradio-kirki-sectioncaption">'. esc_html__( 'Gradient background', "proradio" ).'</h2><p>'. esc_html__( 'All the colors and the direction must be set', "proradio" ).'</p>',
) );


// Gradient buttons

/**
 * ==============================================================
 *	Gradient background
 * ==============================================================
 */


$selectors_list = array(
			'button:not(.owl-dot):not(.proradio-btn__txt):not(.owl-dot):not(.owl-prev):not(.owl-next):not([aria-controls])',
			'input[type="submit"]:not(.proradio-btn__txt)', 
			'.proradio-entrycontent .wp-block-button .wp-block-button__link', 
			'.proradio-entrycontent .wp-block-button .wp-block-file__button', 
			// '.proradio-btn.proradio-active',
			'.proradio-btn-primary', 
			'.woocommerce #respond input#submit',
			'.woocommerce a.button', 
			'.woocommerce button.button', 
			'.woocommerce input.button',
			'.woocommerce a.button',
			'#proradio-body.woocommerce #proradio-master .button',
			'#proradio-body.woocommerce .proradio-master #respond input#submit', 
			'#proradio-body.woocommerce .proradio-master .woocommerce #respond input#submit', 
			'#proradio-body.woocommerce .proradio-master .woocommerce a.button', 
			'#proradio-body.woocommerce .proradio-master .woocommerce button.button', 
			'#proradio-body.woocommerce .proradio-master .woocommerce input.button', 
			'#proradio-body.woocommerce #proradio-master .proradio-woocommerce-content a.button',
			'#proradio-body.woocommerce #proradio-master .proradio-woocommerce-content a.button',  
			'button[type="submit"]::after',
			'a.button'
		);


Kirki::add_field( 'proradio_config', array(
	'type'        => 'toggle',
	'settings'    => 'btn_gradients',
	'label'       => esc_html__( 'Use gradients', "proradio" ),
	'section'     => 'proradio_buttons_section',
	'description' => esc_html__( 'Add extra color pickers to create gradient buttons', "proradio" ),
	// 'priority'    => 0,
	'default'     => '0',
	'transport'   => 'auto',
));

Kirki::add_field( 'proradio_config', array(
	'type'      => 'color',
	'settings'  => 'proradio_btn_color_top',
	'label'     => esc_attr__( 'Top Color', 'mytheme' ),
	'section'   => 'proradio_buttons_section',
	// 'default'   => '#833ab4',
	// 'priority'  => 10,
	'transport'   => 'auto',
	'output'    => array(
		array(
			'element'         => implode(',',$selectors_list),
			'property'        => 'background',
			'value_pattern'   => 'linear-gradient(gDirectiondeg, $ 0%, midCol 50%, bottomCol 100%)',
			'media_query' => '@media (min-width: 100px)',
			 'suffix'   => ' !important',
			'pattern_replace' => array(
				'gDirection'    => 'proradio_btn_color_direction',
				'bottomCol' => 'proradio_btn_color_top_position',
				'midCol'    => 'proradio_btn_color_mid',
			),
		),
	),
	'active_callback' => [
		[
			'setting'  => 'btn_gradients',
			'operator' => '==',
			'value'    => '1',
		]
	],
) );

Kirki::add_field( 'proradio_config', array(
	'type'      => 'color',
	'settings'  => 'proradio_btn_color_mid',
	'label'     => esc_attr__( 'Mid Color', 'mytheme' ),
	'section'   => 'proradio_buttons_section',
	// 'default'   => '#ff0041',
	// 'priority'  => 10,
	'transport'   => 'auto',
	'output'    => array(
		array(
			'element'         => implode(',',$selectors_list),
			'property'        => 'background',
			'value_pattern'   => 'linear-gradient(gDirectiondeg, topCol 0%, $ 50%, bottomCol 100%)',
			'media_query' => '@media (min-width: 100px)',
			 'suffix'   => ' !important',
			'pattern_replace' => array(
				'gDirection'    => 'proradio_btn_color_direction',
				'topCol'    => 'proradio_btn_color_top',
				'bottomCol' => 'proradio_btn_color_top_position',
			),
		),
	),
	'active_callback' => [
		[
			'setting'  => 'btn_gradients',
			'operator' => '==',
			'value'    => '1',
		]
	],
) );

Kirki::add_field( 'proradio_config', array(
	'type'      => 'color',
	'settings'  => 'proradio_btn_color_bottom',
	'label'     => esc_attr__( 'Bottom Color', 'mytheme' ),
	'section'   => 'proradio_buttons_section',
	// 'default'   => '#ff9e00',
	// 'priority'  => 11,
	'transport'   => 'auto',
	'output'    => array(
		array(
			'element'         => implode(',',$selectors_list),
			'property'        => 'background',
			'value_pattern'   => 'linear-gradient(gDirectiondeg, topCol 0%, midCol 50%,  $ 100%)',
			'media_query' => '@media (min-width: 100px)',
			 'suffix'   => ' !important',
			'pattern_replace' => array(
				'topCol'    => 'proradio_btn_color_top',
				'gDirection'    => 'proradio_btn_color_direction',
				'midCol'    => 'proradio_btn_color_mid',
			),
		),
	),
	'active_callback' => [
		[
			'setting'  => 'btn_gradients',
			'operator' => '==',
			'value'    => '1',
		]
	],
) );

Kirki::add_field( 'proradio_config', array(
	'type'      => 'slider',
	'settings'  => 'proradio_btn_color_direction',
	'label'     => esc_attr__( 'Direction', 'mytheme' ),
	'section'   => 'proradio_buttons_section',
	// 'default'   => 0,
	// 'priority'  => 12,
	'transport'   => 'auto',
	'choices'   => array(
		'min'  => 0,
		'max'  => 360,
		'step' => 1,
	),
    'output'    => array(
		array(
			'element'         => implode(',',$selectors_list),
			'property'        => 'background',
			'value_pattern'   => 'linear-gradient($deg, topCol 0%, midCol 50%, bottomCol 100%)',
			'media_query' => '@media (min-width: 100px)',
			 'suffix'   => ' !important',
			'pattern_replace' => array(
				'topCol'    => 'proradio_btn_color_top',
				'bottomCol' => 'proradio_btn_color_bottom',
				'midCol'    => 'proradio_btn_color_mid',
			),
		),
	),
	'active_callback' => [
		[
			'setting'  => 'btn_gradients',
			'operator' => '==',
			'value'    => '1',
		]
	],
) );



/**
 * ==============================================================
 *	Gradient background hover
 * ==============================================================
 
*/
/**
 * ======================================================
 *	Gradient
 * ======================================================
 */

// Hover classes array
$hover_selectors_grad = array();
foreach( $selectors_list as $selector){
	$hover_selectors_grad[] = $selector.':hover::after';
}
$hover_selectors_grad_t =  implode(',',$hover_selectors_grad);
Kirki::add_field( 'proradio_config', array(
    'type'        => 'custom',
    'settings'    => 'sep_buttons_grad_h',
    'label'       => '',
    'section'     => 'proradio_buttons_section',
    'default'     =>  '<h2 class="proradio-kirki-sectioncaption">'. esc_html__( 'Gradient hover', "proradio" ).'</h2>',
    'active_callback' => [
		[
			'setting'  => 'btn_gradients',
			'operator' => '==',
			'value'    => '1',
		]
	],
) );

Kirki::add_field( 'proradio_config', array(
	'type'      => 'color',
	'settings'  => 'proradio_btn_color_top_h',
	'label'     => esc_attr__( 'Top Color hover', 'mytheme' ),
	'section'   => 'proradio_buttons_section',
	// 'default'   => '#833ab4',
	// 'priority'  => 10,
	'transport'   => 'auto',
	'output'    => array(
		array(
			'element'         => $hover_selectors_grad_t,
			'property'        => 'background',
			'value_pattern'   => 'linear-gradient(gDirection_hdeg, $ 0%, midCol_h 50%, bottomCol_h 100%)',
			'media_query' => '@media (min-width: 100px)',
			 'suffix'   => ' !important',
			'pattern_replace' => array(
				'gDirection_h'    => 'proradio_btn_color_direction_h',
				'bottomCol_h' => 'proradio_btn_color_top_position_h',
				'midCol_h'    => 'proradio_btn_color_mid_h',
			),
		),
	),
	'active_callback' => [
		[
			'setting'  => 'btn_gradients',
			'operator' => '==',
			'value'    => '1',
		]
	],
) );

Kirki::add_field( 'proradio_config', array(
	'type'      => 'color',
	'settings'  => 'proradio_btn_color_mid_h',
	'label'     => esc_attr__( 'Mid Color hover', 'mytheme' ),
	'section'   => 'proradio_buttons_section',
	// 'default'   => '#ff0041',
	// 'priority'  => 10,
	'transport'   => 'auto',
	'output'    => array(
		array(
			'element'         => $hover_selectors_grad_t,
			'property'        => 'background',
			'value_pattern'   => 'linear-gradient(ggDirection_hdeg, topCol_h 0%, $ 50%, bottomCol_h 100%)',
			'media_query' => '@media (min-width: 100px)',
			 'suffix'   => ' !important',
			'pattern_replace' => array(
				'gDirection_h'    => 'proradio_btn_color_direction_h',
				'topCol_h'    => 'proradio_btn_color_top_h',
				'bottomCol_h' => 'proradio_btn_color_top_position_h',
			),
		),
	),
	'active_callback' => [
		[
			'setting'  => 'btn_gradients',
			'operator' => '==',
			'value'    => '1',
		]
	],
) );

Kirki::add_field( 'proradio_config', array(
	'type'      => 'color',
	'settings'  => 'proradio_btn_color_bottom_h',
	'label'     => esc_attr__( 'Bottom Color hover', 'mytheme' ),
	'section'   => 'proradio_buttons_section',
	// 'default'   => '#ff9e00',
	// 'priority'  => 11,
	'transport'   => 'auto',
	'output'    => array(
		array(
			'element'         => $hover_selectors_grad_t,
			'property'        => 'background',
			'value_pattern'   => 'linear-gradient(gDirection_hdeg, topCol_h 0%, midCol_h 50%,  $ 100%)',
			'media_query' => '@media (min-width: 100px)',
			 'suffix'   => ' !important',
			'pattern_replace' => array(
				'topCol_h'    => 'proradio_btn_color_top_h',
				'gDirection_h'    => 'proradio_btn_color_direction_h',
				'midCol_h'    => 'proradio_btn_color_mid_h',
			),
		),
	),
	'active_callback' => [
		[
			'setting'  => 'btn_gradients',
			'operator' => '==',
			'value'    => '1',
		]
	],
) );

Kirki::add_field( 'proradio_config', array(
	'type'      => 'slider',
	'settings'  => 'proradio_btn_color_direction_h',
	'label'     => esc_attr__( 'Direction hover', 'mytheme' ),
	'section'   => 'proradio_buttons_section',
	// 'default'   => 0,
	// 'priority'  => 12,
	'transport'   => 'auto',
	'choices'   => array(
		'min'  => 0,
		'max'  => 360,
		'step' => 1,
	),
    'output'    => array(
		array(
			'element'         => $hover_selectors_grad_t,
			'property'        => 'background',
			'value_pattern'   => 'linear-gradient($deg, topCol_h 0%, midCol_h 50%, bottomCol_h 100%)',
			'media_query' => '@media (min-width: 100px)',
			'suffix'   => ' !important',
			'pattern_replace' => array(
				'topCol_h'    => 'proradio_btn_color_top_h',
				'bottomCol_h' => 'proradio_btn_color_bottom_h',
				'midCol_h'    => 'proradio_btn_color_mid_h',
			),
		),
	),
	'active_callback' => [
		[
			'setting'  => 'btn_gradients',
			'operator' => '==',
			'value'    => '1',
		]
	],
) );





