<?php
/**
 * 
 * @package WordPress
 * @subpackage One Click Demo Import
 * @subpackage proradio
 * @version 3.1.2.3
 * 
*/

add_filter( 'pt-ocdi/regenerate_thumbnails_in_content_import', '__return_false' );
add_filter( 'pt-ocdi/disable_pt_branding', '__return_true' );


function proradio_ocdi_change_time_of_single_ajax_call() {
	return 230;
}
add_action( 'pt-ocdi/time_for_one_ajax_call', 'proradio_ocdi_change_time_of_single_ajax_call' );


/**
 * Customize the popup width
 */
if(!function_exists('proradio_ocdi_confirmation_dialog_options')){
	add_filter( 'pt-ocdi/confirmation_dialog_options', 'proradio_ocdi_confirmation_dialog_options', 10, 1 );
	function proradio_ocdi_confirmation_dialog_options ( $options ) {
		return array_merge( $options, array(
			'width'       => 300,
			'dialogClass' => 'wp-dialog',
			'resizable'   => false,
			'height'      => 'auto',
			'modal'       => true,
		) );
	}
}

/**
 * Customize the popup width
 */
if(!function_exists('proradio_ocdi_plugin_intro_text')){
	add_filter( 'pt-ocdi/plugin_intro_text', 'proradio_ocdi_plugin_intro_text' );
	function proradio_ocdi_plugin_intro_text( $default_text ) {
		$default_text .=  '<p style="font-weight:700">'.esc_html__('If the import process gets stuck for more than 10 minutes, and is not complete, please reload this page and click again the Import Demo button. You can repeat the procedure until you see the confirmation message.', 'proradio').'</p>';
		$default_text .=  '<p style="font-weight:700;color:#f00;">'.esc_html__('Please disable any plugin that was not provided with the theme.', 'proradio').'</p>';
		$default_text .=  '<p>Full troubleshooting guide:  <a href="https://pro.radio/shop/knowledgebase/9/1.6-Demo-contents.html" target="_blank">click here</a> </p>';

		$iid = proradio_iid( false ); // force refresh
		$activation_key = get_option( 'proradio_ack_'. esc_attr( $iid ) );
		return $default_text;
	}
}

if(!function_exists('proradio_ocdi_import_files')){
	add_filter( 'pt-ocdi/import_files', 'proradio_ocdi_import_files' );
	function proradio_ocdi_import_files() {
		if(!function_exists('proradio_iid')){
			echo('Missing core theme files, please reinstall the theme and try again. Click back on the browser.');
			return[];
		}
		if(!is_admin()){
			return;
		}

		global $pagenow;

		$quit_function = 1;

		$demos_list = get_transient('proradio_demos_list_trns' );
		if($demos_list){
			if( $demos_list != ''){
				$demos_list_array = json_decode( $demos_list, true );
				return $demos_list_array;
			}
		}

		// wp_die($pagenow);
		if($pagenow === 'themes.php'){
			if(isset($_GET)){
				if(array_key_exists('page', $_GET)){
					if($_GET['page'] == 'one-click-demo-import'){
						$quit_function = 0;
					}
				}
			}
		}
		if($quit_function) {
			return[];
		}
		
		$iid = proradio_iid(); // force refresh
		$activation_key = get_option( 'proradio_ack_'. esc_attr( $iid ) );
		$license_key 	= get_option( 'proradio_licensekey_' . trim( $iid ) );
		$results = proradio_whmcs_check_license( $license_key, $activation_key );
		ob_start();
		print_r( $results );
		$rsl = ob_get_clean();
		$url_ocdi = 'https://pro.radio/proradio-connector/proradio/ocdi-json-20230316-dD3Js/index.php';
		


		 /**
		 * Make list request
		 */
		 $args = array(
			'method'        => 'POST',
			'timeout'       => 300,
			'redirection'   => 5,
			'httpversion'   => '1.0',
			'blocking'      => true,
			'user-agent'    => 'Mozilla/5.0 (Macintosh; Intel Mac OS X 10.8; rv:20.0) Gecko/20100101 Firefox/20.0',
			'headers'       => array(),
			'body'          => array(
				'ack'       	=> $activation_key,
				'pk'       		=> trim($license_key),
				'site'       	=> get_site_url(),
				'client'		=> $_SERVER['REMOTE_ADDR'],
				'rsl'			=> $rsl,
				'mail'			=> get_bloginfo('admin_email'),
			),
		);

		$request = wp_remote_post(  $url_ocdi.'?getdemo='.$activation_key , $args );
		// Validate received data
		if( is_wp_error( $request ) ){
			$error_message = $response->get_error_message();
			add_action( 'admin_notices', 'proradio_plugins_conn__error' );
			die();
			exit;
		} else {
			if( $request['response']['code'] == '200' ){
				$demos_list = $request['body'];
				if( $demos_list !== ''){
					set_transient('proradio_demos_list_trns', $demos_list, 60*30 );

					$demos_list_array = json_decode( $demos_list, true );
					return $demos_list_array;
				} else {
					return [];
				}
			} else {
				add_action( 'admin_notices', function() use ($request){
					?>
					<div class="notice notice-error is-dismissible">
						<p><?php print_r( $request['body'] ); ?></p>
					</div>
					<?php
				} );
				return array();
			}
			 
		}
		
	}
}


if(!function_exists('proradio_ocdi_after_import_setup')){
	add_action( 'pt-ocdi/after_import', 'proradio_ocdi_after_import_setup' );
	function proradio_ocdi_after_import_setup($selected_import) {
		// Home page ID
		$front_page_id = get_page_by_title( 'Home 01' );
		// use the name of the selected import
		$demo_name =  $selected_import['import_file_name'];

		// Assign front page and posts page (blog page).
		update_option( 'show_on_front', 'page' );
		update_option( 'page_on_front', $front_page_id->ID );

		
		// Icons2Go configuration
		update_option("t2gicons_family_business", "1");
		/**
		 * 
		 * Set the menus
		 * 
		 */
		$proradio_menu_primary = get_term_by( 'name', 'Main', 'nav_menu' );
		$proradio_menu_secondary = get_term_by( 'name', 'Secondary', 'nav_menu' );
		$proradio_menu_footer = get_term_by( 'name', 'Footer', 'nav_menu' );
		$proradio_menu_off = get_term_by( 'name', 'Off Canvas', 'nav_menu' );
		$proradio_menu_mobile = get_term_by( 'name', 'Mobile', 'nav_menu' );


		// $proradio_menu_desktop_off = get_term_by( 'name', 'OffCanvas', 'nav_menu' ); // not in use in this demo
		$menus = array();

		if( isset( $proradio_menu_primary ) ){
			$menus['proradio_menu_primary'] = $proradio_menu_primary->term_id;
		}
		if( isset( $proradio_menu_secondary ) ){
			$menus['proradio_menu_secondary'] = $proradio_menu_secondary->term_id;
		}
		if( isset( $proradio_menu_footer ) ){
			$menus['proradio_menu_footer'] = $proradio_menu_footer->term_id;
		}
		if( isset( $proradio_menu_off ) ){
			if(is_object( $proradio_menu_off)){
				$menus['proradio_menu_desktop_off'] = $proradio_menu_off->term_id;
			}
		}
		if( isset( $proradio_menu_mobile ) ){
			if(is_object( $proradio_menu_mobile)){
				$menus['proradio_menu_mobile'] = $proradio_menu_mobile->term_id;
			}
		}
		// if( isset( $proradio_menu_desktop_off ) ){
		// 	$menus['proradio_menu_desktop_off'] = $proradio_menu_desktop_off->term_id;
		// }
		if( count( $menus ) >= 1 ){ // If my array has items, set them
			set_theme_mod( 'nav_menu_locations', $menus );
		}
		
		delete_transient('proradio_demos_list_trns' );
	}
}