<?php
/*
Component: Astroidz - 3d animated background
Plugin URI: https://qantumthemes.com
Description: Creates an nimated background of 3d asteroids
Version: 1.0.2
Author: QantumThemes
Author URI: https://qantumthemes.com
Text Domain: astroidz
Domain Path: /languages
*/

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

define ('PRORADIO_ASTROIDZ_VERSION', '1.0.2');

function proradio_astroidz_plugin_active() {
	return true;
}

/**
 * 
 * =============================================
 * The plugin textdomain
 * =============================================
 * 
 */

if(!function_exists('astroidz_load_plugin_textdomain')){
	add_action( 'plugins_loaded', 'proradio_astroidz_load_plugin_textdomain' );
	function proradio_astroidz_load_plugin_textdomain() {
		load_plugin_textdomain( 'astroidz', FALSE, plugin_dir_path( __FILE__ ) . 'languages' );
	}
}


/**
 * 
 * =============================================
 * Returns current plugin version.
 * =============================================
 * 
 */

if(!function_exists('proradio_astroidz_plugin_get_version') ){
	function proradio_astroidz_plugin_get_version() {
		return PRORADIO_ASTROIDZ_VERSION;
	}
}


/**
 * 
 * =============================================
 * JS enqueue
 * =============================================
 * 
 */

if(!function_exists('proradio_astroidz_scripts')){
	add_action('wp_enqueue_scripts', 'proradio_astroidz_scripts' );
	function proradio_astroidz_scripts() {
		if(!get_theme_mod('astroidz_active')){
			return;
		}
		
		$deps = array("jquery",'jquery-migrate' );
	/*	$required_scripts = array (
			'threeJs' 				=> 'components/astroidz/assets/three/three.min.js',
			'CopyShader' 			=> 'components/astroidz/assets/js/shaders/CopyShader.js',
			'DigitalGlitch' 		=> 'components/astroidz/assets/js/shaders/DigitalGlitch.js',
			'EffectComposer' 		=> 'components/astroidz/assets/js/postprocessing/EffectComposer.js',
			'RenderPass' 			=> 'components/astroidz/assets/js/postprocessing/RenderPass.js',
			'FilmShader' 			=> 'components/astroidz/assets/js/shaders/FilmShader.js',
			'RGBShiftShader' 		=> 'components/astroidz/assets/js/shaders/RGBShiftShader.js',
			'HorizontalBlurShader' 	=> 'components/astroidz/assets/js/shaders/HorizontalBlurShader.js',
			'VerticalBlurShader' 	=> 'components/astroidz/assets/js/shaders/VerticalBlurShader.js',
			'FilmPass' 				=> 'components/astroidz/assets/js/postprocessing/FilmPass.js',
			'MaskPass' 				=> 'components/astroidz/assets/js/postprocessing/MaskPass.js',
			'ShaderPass' 			=> 'components/astroidz/assets/js/postprocessing/ShaderPass.js',
			'GlitchPass' 			=> 'components/astroidz/assets/js/postprocessing/GlitchPass.js',
			'astroidz' 				=> 'components/astroidz/assets/js/astroidz.js'
		);*/

		$required_scripts = array ('astroidz' 				=> 'components/astroidz/assets/js/astroidz-min.js');

		foreach( $required_scripts as $handle => $file){
			wp_enqueue_script( $handle, get_theme_file_uri( $file , __FILE__ ), $deps, PRORADIO_ASTROIDZ_VERSION, true );
			$deps[] = $handle;
		}

		wp_enqueue_style( 'astroidz-style', get_theme_file_uri('components/astroidz/assets/css/astroidz-style.css' , __FILE__ ), array(), PRORADIO_ASTROIDZ_VERSION );
		?>
		<style>
			<?php  
			$colors = get_theme_mod( 'astroidz_bg' );
			?>
			#astroidzContainer {
				background: radial-gradient(ellipse at center, <?php echo esc_attr( $colors['inner']); ?> 0%, <?php echo esc_attr( $colors['outer'] ); ?> 60%);
			}
		</style>
		<?php
	}
}


if(!function_exists('proradio_astroidz_custom_colors')){
	add_action('wp_footer', 'proradio_astroidz_custom_colors');
	function proradio_astroidz_custom_colors(){
		if(!get_theme_mod('astroidz_active')){
			return;
		}
		?>
			<div id="astroidzStyles"
			data-astroidz-quantity="<?php echo esc_attr( get_theme_mod( 'astroidz_quantity', 20 )); ?>"
			data-astroidz-glitchPass="<?php echo esc_attr( get_theme_mod( 'astroidz_glitchPass' )); ?>" 
			data-astroidz-effectFilm="<?php echo esc_attr( get_theme_mod( 'astroidz_effectFilm' )); ?>" 
			data-astroidz-effectBlur="<?php echo esc_attr( get_theme_mod( 'astroidz_effectBlur' )); ?>" 
			data-astroidz-light0i="<?php echo esc_attr( get_theme_mod( 'astroidz_light0i' )); ?>" 
			data-astroidz-light1i="<?php echo esc_attr( get_theme_mod( 'astroidz_light1i' )); ?>" 
			data-astroidz-light2i="<?php echo esc_attr( get_theme_mod( 'astroidz_light2i' )); ?>" 
			data-astroidz-light3i="<?php echo esc_attr( get_theme_mod( 'astroidz_light3i' )); ?>" 
			data-astroidz-light0="<?php echo esc_attr( get_theme_mod( 'astroidz_light0' )); ?>" 
			data-astroidz-light1="<?php echo esc_attr( get_theme_mod( 'astroidz_light1' )); ?>" 
			data-astroidz-light2="<?php echo esc_attr( get_theme_mod( 'astroidz_light2' )); ?>" 
			data-astroidz-light3="<?php echo esc_attr( get_theme_mod( 'astroidz_light3' )); ?>" 
			data-astroidz-material1="<?php echo esc_attr( get_theme_mod( 'astroidz_material1' )); ?>" 
			data-astroidz-material2="<?php echo esc_attr( get_theme_mod( 'astroidz_material2' )); ?>">
			</div>
		<?php  
	}
}


/*
 *	Design settings for single page
 *	=============================================================
 */

if(!function_exists("proradio_astroidz_custom_page_fields_settings")){
	add_action('init', 'proradio_astroidz_custom_page_fields_settings');  
	function proradio_astroidz_custom_page_fields_settings() {

		if(!get_theme_mod('astroidz_active')){
			return;
		}


		$settings = array (
			array (
				'label' =>  esc_html__('Astroidz Background',"proradio"),
				'id' =>  'astroidz_page_bg',
				'default' => false,
				'desc'	=> esc_html__('Override customizer option for Astroidz background', 'proradio'),
				'type' 	=> 'select',
				'options' => array (
					array('label' => esc_attr__( 'Enabled', "astroidz" ), 'value' => 'on' ),	
					array('label' => esc_attr__( 'Disabled', "astroidz" ), 'value' => 'off' ),	
				)
			)
		);
		if(class_exists('Custom_Add_Meta_Box')){
			$label = esc_attr__('Astroidz background Options');

			$settingsbox = new Custom_Add_Meta_Box('astroidz_page_options', $label , $settings, 'page', true );
			/**
			 * Add custom header settings to any post type
			 */
			$settingsbox = new Custom_Add_Meta_Box('astroidz_page_options', $label, $settings, 'members', true );
			$settingsbox = new Custom_Add_Meta_Box('astroidz_page_options', $label, $settings, 'shows', true );
			$settingsbox = new Custom_Add_Meta_Box('astroidz_page_options', $label, $settings, 'podcast', true );
			$settingsbox = new Custom_Add_Meta_Box('astroidz_page_options', $label, $settings, 'event', true );
			$settingsbox = new Custom_Add_Meta_Box('astroidz_page_options', $label, $settings, 'chart', true );
			$settingsbox = new Custom_Add_Meta_Box('astroidz_page_options', $label, $settings, 'radiochannel', true );
			$settingsbox = new Custom_Add_Meta_Box('astroidz_page_options', $label, $settings, 'post', true );
			$settingsbox = new Custom_Add_Meta_Box('astroidz_page_options', $label, $settings, 'product', true );
		}
	}
}

	
if ( ! function_exists( 'proradio_astroidz_body_class' ) ) {
	add_filter('body_class', 'proradio_astroidz_body_class');	
	function proradio_astroidz_body_class($classes){

		if(get_theme_mod('astroidz_active')){
			$specialClass = '';
			if( '1' == get_theme_mod('astroidz_cover_desktop','1')){
				$specialClass =  'astroidz-status-on';
			} else {
				$specialClass =  'astroidz-status-off';
			}
			if(is_single() || is_singular()){
				$astroids_status = get_post_meta( get_the_ID(), 'astroidz_page_bg', true ); 
				if( $astroids_status == 'on' || $astroids_status == 'off'){
					$specialClass =  esc_attr( 'astroidz-status-'.esc_attr( $astroids_status ) );
				}
			}
			$classes[] = $specialClass;
		}
		
		return $classes;
	}
}


// Configuration for the Astroidz plugin
if ( function_exists('proradio_astroidz_plugin_active') &&  class_exists( 'Kirki' ) ) {
	require_once  get_theme_file_path( '/components/astroidz/kirki-configuration-astroidz/kirki-setup.php' ); 
}



