<?php 
/**
 * Spare functions to extract audio from contents
 */
// qtmplayer_replace_default

if(!function_exists('qtmplayer_audio_shortcode')){
	add_filter( 'wp_audio_shortcode_override', 'qtmplayer_audio_shortcode', 10, 2 );
	function qtmplayer_audio_shortcode( $html, $attr ) {
		if(get_theme_mod( 'qtmplayer_replace_default', '1' ) && !is_admin() ){
			
			ob_start();

			// Post common data:
			$id = get_the_ID();
			$content = get_the_content( $id);
			$tracktitle = get_the_title($id);
			$artist = get_the_author();
			$link = get_the_permalink($id);
			$cover = '';
			$thumb = false;
			if( has_post_thumbnail( $id )) {
				$cover = get_the_post_thumbnail_url(null,array(370,370));
				$thumb = get_the_post_thumbnail_url(null,array(70,70));
			}

			
			// Download or buy
			$buylink =  get_post_meta(  $id, 'qtmplayer_dll', true);
			$ext = pathinfo($buylink, PATHINFO_EXTENSION);
			if( $ext == 'mp3'){
				$buylink = qtmplayer_create_dllink( $buylink );
			}

			
			$track = array();

			// audio shortcode specific data
			if(array_key_exists('mp3', $attr)){
				$file = $attr['mp3'];
			} elseif (array_key_exists(0, $attr)){
				$file = $attr[0];
			}

			/**
			 * Since 1.2.0
			 * Make sure no duplicated block occurs
			 */
			$blocks = parse_blocks( $content );
			$audio = false;
			foreach ($blocks as $block){
				if($block['blockName'] == 'core/audio'){
					$audio = $block[ 'innerHTML' ];
					if( $audio ){
						$audio = true;
						return;
					}
				}
			}

			if(!isset( $file ) && !$audio){
				$audio_file = get_post_meta( $id, 'enclosure', true );
				if( $audio_file ) {
					$file = $audio_file;
					// Podctrac compatibility change
					$arr = explode("pts/redirect.mp3/", $file );
					if( count( $arr) > 1 ){
						$file = $arr[1];
					}
					// Podctrac end
					$arr = explode('.mp3', $file);
					if(count($arr) > 0){
						$file = $arr[0].'.mp3';
						// remove redirects
						$arr = explode('http', $file);
						if( count($arr) > 2) {
							$file = 'http'.urldecode($arr[2]);
						}
					}
				}
			}

			// SINCE 2020 03 26
			// powerpress compatibility
			// Find any field called enclosure something
			// For compatibility with PowerPress
			if(!isset( $file )){
				$all_metas = get_post_meta( $id ) ;
				$key = preg_grep('/enclosure/', array_keys($all_metas));
				if( $key ){
					$value = $all_metas[current( $key )];
					if( is_array($value) && count($value) > 0 ){
						$file_val = $value[0];
						$arr2= explode("\n", $file_val );
						if( count( $arr2) > 1 ){
							$file_val = $arr2[0]; // should do the trick
						}
						if (strpos($file_val, '.mp3') !== false) {
						    $file = $file_val;
						}
					}
				}
			}




			$album = '';

			if(isset( $file )){
				$mp3id = attachment_url_to_postid($file);
				if($mp3id){
					if($mp3id){
						$meta = wp_get_attachment_metadata($mp3id);
						if($meta){
							if(array_key_exists('title', $meta)){
								if($meta['title'] !== ''){
									$tracktitle	= $meta['title'];
								}
							}
							if(array_key_exists('artist', $meta)){
								if($meta['artist'] !== ''){
									$artist	= $meta['artist'];
								}
							}
							if(array_key_exists('album', $meta)){
								if($meta['album'] !== ''){
									$album	= $meta['album'];
								}
							}
						}
					}
				}
				$track_data = array(
					'img_id' 		=> $id,
					'title'			=> $tracktitle,
					'artist_name'	=> $artist,
					'album'			=> $album,
					'buyurl'		=> $buylink,
					'icon'			=> 'download',
					'link'			=> $link,
					'price'			=>	'',
					'file'			=> $file,
				);
				echo qtmplayer_create_singletrack($track_data);
			}

			$html = ob_get_clean();

			/**
			 * Display the tracklist below the player
			 * @var array
			 */
			$atts = array(
				'file' => $file, /* @since PR.3.9.4 [2022 03 23] */
				'id' => $id ,
				'title_classes'	=> false,
				'classes' => 'qtmplayer-tracklist__autogenerated qtmplayer-tracklist__after', // additional container classes
				'print' => false // include the echo function
			);
			if(function_exists('qtmplayer_tracklist') && ( 'podcast' === get_post_type( $id ) || 'post' === get_post_type( $id ))) {
				$html .= qtmplayer_tracklist( $atts );
			}
		}
	    return $html;
	}
}



if(!function_exists('qtmplayer_playlist_shortcode')){
	add_filter( 'post_playlist', 'qtmplayer_playlist_shortcode', 10, 2 );
	function qtmplayer_playlist_shortcode( $html, $attr ) {
		
		if(get_theme_mod( 'qtmplayer_replace_default', '1' ) && !is_admin() ){
			/**
			 * Special playlist created from WP playlist
			 * Extract songs from embedded playlist
			 */
			
			ob_start();
			// Post common data:
			$id = get_the_ID();
			$content = get_the_content( $id);
			$tracktitle = get_the_title($id);
			$artist = get_the_author();
			$link = get_the_permalink($id);
			$cover = '';
			$thumb = false;
			if( has_post_thumbnail( $id )) {
				$cover = get_the_post_thumbnail_url(null,array(370,370));
				$thumb = get_the_post_thumbnail_url(null,array(70,70));
			}

			
			// Download or buy
			$buylink =  get_post_meta(  $id, 'qtmplayer_dll', true);
			$ext = pathinfo($buylink, PATHINFO_EXTENSION);
			if( $ext == 'mp3'){
				$buylink = qtmplayer_create_dllink( $buylink );
			}

			
			$track = array();


			if ( has_shortcode($content, 'playlist') ) { 
				$pattern = get_shortcode_regex();
				preg_match_all('/'.$pattern.'/s', $content, $matches);
				$lm_shortcode = array_keys($matches[2],'playlist'); // lista di tutti gli ID di shortcodes di tipo playlist. Se ne ho 1 torna 0
				ob_start();
				if (count($lm_shortcode) > 0) {
					$buylink_std = '';
					$buy_links = get_post_meta(get_the_id(), 'track_repeatablebuylinks', false);
					if(array_key_exists(0, $buy_links)){
						$data = $buy_links[0];
						if(count($data)>0){
							$buylink_std = $data[0]['cbuylink_url'];
						}
					}
					foreach($lm_shortcode as $sc) {
						$string_data =  $matches[3][$sc];
						$array_param = shortcode_parse_atts($string_data);
						if(array_key_exists("ids",$array_param)){
							$ids_array = explode(',', $array_param['ids']);
							foreach($ids_array as $audio_id){
								$tracktitle = get_the_title($audio_id);
								$metadata = wp_get_attachment_metadata($audio_id);
								$artist = '';
								if(array_key_exists('artist', $metadata)){
									$artist = $metadata['artist'];
								}
								$file = wp_get_attachment_url($audio_id);
								$buyurl = false; // for now we have no buy URL for drop-in tracks (how can we? Copy buy from album?)
								$icon = '';
								$track_index = str_pad($n, 2 , "0", STR_PAD_LEFT);
								$track_data = array(
									'img_id' 		=> $id,
									'title'			=> $tracktitle,
									'artist_name'	=> $artist,
									'album'			=> '',
									'buyurl'		=> $buylink,
									'icon'			=> 'download',
									'link'			=> $link,
									'price'			=>	'',
									'file'			=> $file,
								);
								echo qtmplayer_create_singletrack($track_data);
								$n = $n + 1;
							}
						}
						$active = '';
					}	   
				}
				echo  ob_get_clean();
			}

			$html = ob_get_clean();

			/**
			 * Display the tracklist below the player
			 * @var array
			 */
			$atts = array(
				'id' => $id ,
				'title_classes'	=> false,
				'classes' => 'qtmplayer-tracklist__autogenerated qtmplayer-tracklist__after', // additional container classes
				'print' => false // include the echo function
			);
			if(function_exists('qtmplayer_tracklist') && 'podcast' === get_post_type( $id )) {
				$html .= qtmplayer_tracklist( $atts );
			}
		}// qtmplayer_replace_default  = 1
		return $html;
	}
}







