<?php
/**
 * @package WordPress
 * @subpackage proradio
 * @version 1.0.0
 * Carousel design fields
*/

namespace ProradioElementor\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Core\Schemes\Typography;


add_action('elementor/element/before_section_end', function( $section, $section_id, $args ) {

	if( $section_id == 'proradio_elementor_section_item_design_global' ){
			$section->add_responsive_control(
				'proradio-captionsize',
				[
					'label' => esc_html__( 'Caption size', 'elementor-proradio' ),
					'type' => \Elementor\Controls_Manager::SLIDER,
					'range' => [
						'px' => [
							'min' => 12,
							'max' => 60,
						],
					],
					'devices' => [ 'desktop', 'tablet', 'mobile' ],
					'selectors' => [
						'{{WRAPPER}} .proradio-post__title  ' => 'font-size: {{SIZE}}{{UNIT}};',
					],
				]
			);


			$section->add_control(
				'proradio-showmeta',
				[
					'label' => esc_html__( 'Display meta info', 'plugin-domain' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'devices' => [ 'desktop', 'tablet', 'mobile' ],
					'default' => 'block',
					'options' =>[
						"block" => esc_html__( "Yes", 'proradio' ),
						"none" => esc_html__( "No", 'proradio' ),
					],
					'selectors' => [
						'{{WRAPPER}} .proradio-meta  ' => 'display: {{VALUE}};',
					],
				]
			);
			$section->add_control(
				'proradio-showcat',
				[
					'label' => esc_html__( 'Display category', 'plugin-domain' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'default' => 'block',
					'options' =>[
						"block" => esc_html__( "Yes", 'proradio' ),
						"none" => esc_html__( "No", 'proradio' ),
					],
					'selectors' => [
						'{{WRAPPER}} .proradio-cats  ' => 'display: {{VALUE}};',
					],
				]
			);
			$section->add_control(
				'proradio-showactions',
				[
					'label' => esc_html__( 'Display actions icon', 'plugin-domain' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'devices' => [ 'desktop', 'tablet', 'mobile' ],
					'default' => 'block',
					'options' =>[
						"block" => esc_html__( "Yes", 'proradio' ),
						"none" => esc_html__( "No", 'proradio' ),
					],
					'selectors' => [
						'{{WRAPPER}} .proradio-actions' => 'display: {{VALUE}};',
					],
				]
			);
			$section->add_responsive_control(
				'proradio-items-padding',
				[
					'label' => __( 'Content padding', 'kentha-elementor' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'devices' => [ 'desktop', 'tablet', 'mobile' ],
			
					'selectors' => [
						'{{WRAPPER}} .proradio-post__content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$section->add_responsive_control(
				'proradio-padding-header',
				[
					'label' => __( 'Header padding', 'kentha-elementor' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'devices' => [ 'desktop', 'tablet', 'mobile' ],
			
					'selectors' => [
						'{{WRAPPER}} .proradio-post__headercont' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

	}
}, 10, 3 );