<?php  
/**
 * Form
 * @package proradio-dedications
 * @version 1.0
 *  
 * */

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


if(!function_exists('prdedications_form_function')){
	
	add_shortcode( 'proradio-dedications', 'prdedications_form_function' );


	function prdedications_form_function(){
		$actual_link = add_query_arg('sendmail', date("YmdHisu"), get_the_permalink() );

		?>
		<div class="prdedications prdedications-container">
			 <form action="<?php echo esc_url($actual_link); ?>" method="post" class="prdedications-cform-form init" novalidate="novalidate" data-status="init">
				<p class="prdedications-fighter">
					<label><?php esc_html_e(  "Your name (public)", 'proradio-dedications'); ?>* <br>
					<input type="text" name="name">
					<label><?php esc_html_e(  "Your email", 'proradio-dedications'); ?>*<br>
					<input type="text" name="email">
				</p>

				<?php if(get_option('prdedications-request-name')): ?>
					<p><label><?php esc_html_e(  "Your name (public)", 'proradio-dedications'); ?>* <br>
					    <span class="prdedications-cform-form-control-wrap" data-name="your-name"><input type="text" name="your-name" value="" size="40" class="prdedications-cform-form-control prdedications-cform-text prdedications-cform-validates-as-required" aria-required="true" aria-invalid="false"></span> </label>
						<span class="prdedications-error-message your-name-error"><?php esc_html_e('Please complete this information', 'proradio-dedications'); ?></span>
					</p>
				<?php endif; ?>

				<?php if(get_option('prdedications-request-email')): ?>
					<p><label><?php esc_html_e(  "Your email", 'proradio-dedications'); ?>* (<?php esc_html_e(  "Will not be public", 'proradio-dedications'); ?>)<br>
					    <span class="prdedications-cform-form-control-wrap" data-name="your-email"><input type="email" name="your-email" value="" size="40" class="prdedications-cform-form-control prdedications-cform-text prdedications-cform-email prdedications-cform-validates-as-required prdedications-cform-validates-as-email" aria-required="true" aria-invalid="false"></span> </label>
					    <span class="prdedications-error-message your-email-error"><?php esc_html_e('Please check the email address', 'proradio-dedications'); ?></span>
					</p>
				<?php endif; ?>

				<?php if(get_option('prdedications-request-phone')): ?>
					<p><label><?php esc_html_e(  "Your phone", 'proradio-dedications'); ?> (<?php esc_html_e(  "Will not be public", 'proradio-dedications'); ?>)<br>
					    <span class="prdedications-cform-form-control-wrap" data-name="your-phone"><input type="text" name="your-phone" value="" size="40" class="prdedications-cform-form-control prdedications-cform-text" aria-invalid="false"></span> </label>
					</p>
				<?php endif; ?>
				<div class="proradio-dedications-message-container">
					<p><label><?php esc_html_e(  "Write your dedication", 'proradio-dedications'); ?><br>
					    <span class="prdedications-cform-form-control-wrap" data-name="your-message"><textarea name="your-message" cols="40" rows="10" class="prdedications-cform-form-control prdedications-message prdedications-cform-textarea" aria-invalid="false"></textarea></span> </label>

					     <span class="prdedications-error-message your-message-error"><?php esc_html_e('Please write something more', 'proradio-dedications'); ?></span>
					</p>
				</div>
				

				<?php if(get_option('prdedications-request-song')): ?>
					<div class="prdedications-request-song">
						<label><?php esc_html_e(  "Song request", 'proradio-dedications'); ?><br></label>
						<div class="prdedications-song-search">
						    <span class="prdedications-cform-form-control-wrap " data-name="your-song">
						    	<input type="text" name="your-song" value="" size="100" class="prdedications-cform-form-control prdedications-cform-text prdedications-songsearch" aria-invalid="false">
						    	<span class="proradio-btn proradio-btn__r"><i class="material-icons">search</i></span>
						    </span> 
							<div class="prdedications-suggestions">
							</div>
						</div>
						<input type="hidden" name="song-artwork"  aria-invalid="false">
					</div>
				<?php endif; ?>


				<?php if(get_option('prdedications-request-privacy')): ?>
				<p>
					<span class="prdedications-cform-form-control-wrap" data-name="privacy">
					
						<label>
							<input type="checkbox" name="privacy" value="I read and accept the privacy terms">
							<span class="prdedications-cform-list-item-label">
								<?php esc_html_e("I read and accept the privacy terms.",'proradio-dedications'); ?>
							</span>
						</label>
					</span>
					<span class="prdedications-error-message privacy-error"><?php esc_html_e('Please accept the privacy terms to proceed.', 'proradio-dedications'); ?></span>
				</p>
				<?php endif; ?>

				
				<div class="prdedications-response-success" aria-hidden="true"><?php esc_html_e(  "Thank you for your submission", 'proradio-dedications'); ?></div>
				<div class="prdedications-response-error" aria-hidden="true"><?php esc_html_e(  "Sorry, there was an error submitting the message", 'proradio-dedications'); ?></div>
				<div class="prdedications-response-limit" aria-hidden="true"><?php esc_html_e(  "Please wait for previous dedications to be approved before submitting new ones", 'proradio-dedications'); ?></div>

				<p class="prdedications-submitrow"><button type="submit" class="prdedications-cform-submit prdedications-cform-form-control has-spinner prdedications-cform-submit sc_button_hover_slide_left"><i class="material-icons">send</i> <?php  esc_html_e("Submit",'proradio-dedications'); ?></button><span class="prdedications-spinner "></span></p>
				
				
			</form>
		</div>
		<?php  
	}
}
