<?php
session_start();
if (!isset($_SESSION['admin'])) {
    header('Location: index.php'); // Redirigir si no hay sesión activa
    exit();
}

include('bd/db.php'); // Conexión a la base de datos

// Exportar a Excel
if (isset($_GET['exportar']) && $_GET['exportar'] === 'excel') {
    header('Content-Type: application/vnd.ms-excel');
    header('Content-Disposition: attachment; filename="temas_musicales.xls"');
    header('Pragma: no-cache');
    header('Expires: 0');

    $sql_exportar = "SELECT tema, artista FROM musica";
    $result_exportar = $conn->query($sql_exportar);

    echo "Tema\tArtista\n";
    while ($row = $result_exportar->fetch_assoc()) {
        echo $row['tema'] . "\t" . $row['artista'] . "\n";
    }
    exit();
}

// Consultar categorías disponibles
$sql_categorias = "SELECT id, nombre_categoria FROM categorias";
$result_categorias = $conn->query($sql_categorias);

// Obtener la categoría seleccionada
$categoria_id = isset($_GET['categoria_id']) ? intval($_GET['categoria_id']) : 1;

// Consultar temas según la categoría seleccionada
$sql_temas = "SELECT id, tema, artista FROM musica WHERE categoria_id = ?";
$stmt_temas = $conn->prepare($sql_temas);
$stmt_temas->bind_param("i", $categoria_id);
$stmt_temas->execute();
$result_temas = $stmt_temas->get_result();

// Actualizar datos mediante petición AJAX
if (isset($_POST['campo']) && isset($_POST['valor']) && isset($_POST['id'])) {
    $campo = $_POST['campo'];
    $valor = htmlspecialchars($_POST['valor']);
    $id = intval($_POST['id']);

    if (in_array($campo, ['tema', 'artista'])) {
        $sql_actualizar = "UPDATE musica SET $campo = ? WHERE id = ?";
        $stmt_actualizar = $conn->prepare($sql_actualizar);
        $stmt_actualizar->bind_param("si", $valor, $id);
        $stmt_actualizar->execute();

        echo "Actualizado correctamente";
        exit();
    }
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Gestión de Música</title>
    <style>
        body {
            margin: 0;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-image: url('img/fo1.jpeg');
            background-size: cover;
            background-position: center;
            background-attachment: fixed;
            color: #333;
        }
        .content-container {
            margin: 20px auto;
            width: 90%;
            max-width: 1200px;
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            text-align: center;
        }
        h2 {
            color: #0078D7;
            margin-bottom: 20px;
        }
        .buttons {
            margin-bottom: 20px;
        }
        .buttons select, .buttons button {
            padding: 10px;
            border-radius: 5px;
            font-size: 16px;
            margin-right: 10px;
        }
        table {
            width: 90%;
            margin: 0 auto;
            border-collapse: collapse;
            background-color: white;
            border-radius: 10px;
            overflow: hidden;
        }
        table, th, td {
            border: 1px solid #ddd;
        }
        th, td {
            padding: 10px;
            text-align: left;
            color: #333;
        }
        th {
            background-color: #0078D7;
            color: white;
        }
        .editable {
            cursor: pointer;
            position: relative;
        }
        .editable:hover::after {
            content: '✏️';
            position: absolute;
            right: 5px;
            top: 50%;
            transform: translateY(-50%);
        }
        .editable[contenteditable="true"] {
            background-color: #f0f8ff;
            outline: 1px dashed #0078D7;
        }
    </style>
</head>
<body>
    <?php include('cabecera.php'); ?>

    <div class="content-container">
        <h2>Gestión de Música por Categoría</h2>

        <div class="buttons">
            <form method="get" action="">
                <select name="categoria_id" onchange="this.form.submit()">
                    <?php while ($row_categoria = $result_categorias->fetch_assoc()): ?>
                        <option value="<?php echo $row_categoria['id']; ?>" <?php echo $categoria_id == $row_categoria['id'] ? 'selected' : ''; ?>>
                            <?php echo $row_categoria['nombre_categoria']; ?>
                        </option>
                    <?php endwhile; ?>
                </select>
                <a href="?exportar=excel" style="text-decoration: none;">
                    <button type="button">📥 Exportar a Excel</button>
                </a>
            </form>
        </div>

        <table>
            <thead>
                <tr>
                    <th>Tema</th>
                    <th>Artista</th>
                </tr>
            </thead>
            <tbody>
                <?php while ($row = $result_temas->fetch_assoc()): ?>
                    <tr>
                        <td class="editable" contenteditable="false" data-id="<?php echo $row['id']; ?>" data-campo="tema">
                            <?php echo htmlspecialchars($row['tema']); ?>
                        </td>
                        <td class="editable" contenteditable="false" data-id="<?php echo $row['id']; ?>" data-campo="artista">
                            <?php echo htmlspecialchars($row['artista']); ?>
                        </td>
                    </tr>
                <?php endwhile; ?>
            </tbody>
        </table>
    </div>

    <?php include('pie.php'); ?>

    <script>
        document.addEventListener('DOMContentLoaded', () => {
            const celdasEditables = document.querySelectorAll('.editable');

            celdasEditables.forEach(celda => {
                celda.addEventListener('click', () => {
                    celda.contentEditable = true;
                    celda.focus();
                });

                celda.addEventListener('blur', () => {
                    celda.contentEditable = false;
                    const id = celda.getAttribute('data-id');
                    const campo = celda.getAttribute('data-campo');
                    const valor = celda.textContent.trim();

                    fetch('', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/x-www-form-urlencoded'
                        },
                        body: `id=${id}&campo=${campo}&valor=${encodeURIComponent(valor)}`
                    })
                    .then(response => response.text())
                    .then(data => {
                        console.log(data);
                        alert('Actualizado correctamente');
                    })
                    .catch(error => console.error('Error:', error));
                });
            });
        });
    </script>
</body>
</html>
