<?php
session_start();
if (!isset($_SESSION['admin'])) {
    header('Location: index.php'); // Redirigir si no hay sesión activa
    exit();
}

include('bd/db.php'); // Conexión a la base de datos

// Consultar sesiones guardadas
$sql_sesiones = "SELECT id, nombre_sesion, DATE_FORMAT(fecha_guardado, '%d/%m/%Y %H:%i:%s') AS fecha_guardado FROM sesiones ORDER BY fecha_guardado DESC";
$result_sesiones = $conn->query($sql_sesiones);

if (!$result_sesiones) {
    die("Error en la consulta SQL: " . $conn->error);
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sesiones Guardadas</title>
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-color: #f4f4f4;
            margin: 0;
            padding: 0;
        }
        .content-container {
            margin: 20px auto;
            width: 90%;
            max-width: 800px;
            background: white;
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
        }
        h2 {
            color: #0078D7;
            text-align: center;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        th, td {
            text-align: left;
            padding: 10px;
            border: 1px solid #ddd;
        }
        th {
            background-color: #0078D7;
            color: white;
        }
        .btn-download {
            background-color: #28a745;
            color: white;
            border: none;
            padding: 8px 15px;
            border-radius: 5px;
            cursor: pointer;
            text-decoration: none;
        }
        .btn-download:hover {
            background-color: #218838;
        }
        .no-sesiones {
            text-align: center;
            color: #666;
            margin-top: 20px;
        }
    </style>
</head>
<body>
    <?php include('cabecera.php'); ?>

    <div class="content-container">
        <h2>Sesiones Guardadas</h2>

        <?php if ($result_sesiones->num_rows > 0): ?>
            <table>
                <thead>
                    <tr>
                        <th>Nombre de la Sesión</th>
                        <th>Fecha de Guardado</th>
                        <th>Descargar</th>
                    </tr>
                </thead>
                <tbody>
                    <?php while ($row = $result_sesiones->fetch_assoc()): ?>
                        <tr>
                            <td><?php echo htmlspecialchars($row['nombre_sesion']); ?></td>
                            <td><?php echo htmlspecialchars($row['fecha_guardado']); ?></td>
                            <td>
                                <a href="sesiones/<?php echo htmlspecialchars($row['nombre_sesion']); ?>.xlsx" class="btn-download" download>
                                    Descargar
                                </a>
                            </td>
                        </tr>
                    <?php endwhile; ?>
                </tbody>
            </table>
        <?php else: ?>
            <div class="no-sesiones">No hay sesiones guardadas actualmente.</div>
        <?php endif; ?>
    </div>
</body>
</html>
