<?php
session_start();
if (!isset($_SESSION['admin'])) {
    header('Location: index.php'); // Redirigir si no hay sesión activa
    exit();
}

include('bd/db.php'); // Conexión a la base de datos

// Verificar si se recibe el ID del cliente
if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    die("ID de cliente no válido.");
}

$cliente_id = intval($_GET['id']);

// Obtener datos del cliente
$sql_cliente = "SELECT * FROM clientes WHERE id = ?";
$stmt_cliente = $conn->prepare($sql_cliente);
$stmt_cliente->bind_param("i", $cliente_id);
$stmt_cliente->execute();
$result_cliente = $stmt_cliente->get_result();

if ($result_cliente->num_rows === 0) {
    die("Cliente no encontrado.");
}

$cliente = $result_cliente->fetch_assoc();

// Actualizar datos del cliente
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $nombre = htmlspecialchars($_POST['nombre']);
    $telefono = htmlspecialchars($_POST['telefono']);

    $sql_actualizar = "UPDATE clientes SET nombre = ?, telefono = ? WHERE id = ?";
    $stmt_actualizar = $conn->prepare($sql_actualizar);
    $stmt_actualizar->bind_param("ssi", $nombre, $telefono, $cliente_id);

    if ($stmt_actualizar->execute()) {
        $mensaje = "Datos del cliente actualizados correctamente.";
        // Actualizar los datos cargados
        $cliente['nombre'] = $nombre;
        $cliente['telefono'] = $telefono;
    } else {
        $mensaje = "Error al actualizar los datos del cliente.";
    }
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Editar Cliente</title>
    <style>
        body {
            margin: 0;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-image: url('img/fo2.jpeg');
            background-size: cover;
            background-position: center;
            background-attachment: fixed;
            color: #333;
        }
        .content-container {
            margin: 20px auto;
            width: 80%;
            max-width: 800px;
            background: rgba(255, 255, 255, 0.9);
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            text-align: center;
        }
        h2 {
            color: #0078D7;
        }
        form {
            display: flex;
            flex-direction: column;
            align-items: center;
        }
        input {
            margin: 10px 0;
            padding: 10px;
            width: 90%;
            max-width: 600px;
            border-radius: 5px;
            border: 1px solid #ccc;
        }
        button {
            background-color: #0078D7;
            color: white;
            border: none;
            padding: 10px 20px;
            border-radius: 20px;
            font-weight: bold;
            cursor: pointer;
            margin-top: 20px;
        }
        button:hover {
            background-color: #005BB5;
        }
        .message {
            background-color: #DFF2BF;
            color: #4F8A10;
            padding: 10px;
            border: 1px solid #4F8A10;
            border-radius: 5px;
            margin-bottom: 20px;
        }
    </style>
</head>
<body>
    <?php include('cabecera.php'); ?>

    <div class="content-container">
        <h2>Editar Cliente</h2>

        <?php if (isset($mensaje)): ?>
            <div class="message"><?php echo $mensaje; ?></div>
        <?php endif; ?>

        <form action="" method="post">
            <input type="text" name="nombre" value="<?php echo htmlspecialchars($cliente['nombre']); ?>" placeholder="Nombre del Cliente" required>
            <input type="text" name="telefono" value="<?php echo htmlspecialchars($cliente['telefono']); ?>" placeholder="Teléfono del Cliente" required>
            <button type="submit">Guardar Cambios</button>
        </form>
    </div>

    <?php include('pie.php'); ?>
</body>
</html>
