<?php
session_start();
if (!isset($_SESSION['admin'])) {
    header('Location: index.php'); // Redirigir si no hay sesión activa
    exit();
}

include('bd/db.php'); // Conexión a la base de datos
require_once '/home/fdaqfoui/vendor/autoload.php'; // Asegúrate de tener PhpSpreadsheet instalado

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

// Exportar clientes totales a Excel
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['exportar_excel'])) {
    // Consultar todos los clientes totales
    $sql_clientes_totales = "
        SELECT c.nombre, c.telefono, 
               GROUP_CONCAT(CONCAT(IFNULL(m.tema, '(Pedido Especial)'), ' - ', p.estado) SEPARATOR '; ') AS historial
        FROM clientes_totales c
        LEFT JOIN pedidos p ON c.id = p.cliente_id
        LEFT JOIN musica m ON p.tema = m.tema
        GROUP BY c.id";
    $result_clientes_totales = $conn->query($sql_clientes_totales);

    if ($result_clientes_totales->num_rows > 0) {
        $spreadsheet = new Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();

        // Configurar encabezados en el archivo Excel
        $sheet->setCellValue('A1', 'Nombre');
        $sheet->setCellValue('B1', 'Teléfono');
        $sheet->setCellValue('C1', 'Historial de Canciones');
        $rowIndex = 2;

        while ($row = $result_clientes_totales->fetch_assoc()) {
            $sheet->setCellValue("A$rowIndex", $row['nombre']);
            $sheet->setCellValue("B$rowIndex", $row['telefono']);
            $sheet->setCellValue("C$rowIndex", $row['historial']);
            $rowIndex++;
        }

        // Guardar archivo Excel
        $ruta_excel = "exportes/clientes_totales_" . date('Ymd_His') . ".xlsx";
        $writer = new Xlsx($spreadsheet);
        $writer->save($ruta_excel);

        // Descarga del archivo Excel
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment; filename="clientes_totales.xlsx"');
        readfile($ruta_excel);
        exit();
    } else {
        $mensaje = "No hay clientes totales para exportar.";
    }
}

// Consultar todos los clientes totales
$sql_clientes_totales = "
    SELECT c.nombre, c.telefono, 
           GROUP_CONCAT(CONCAT(IFNULL(m.tema, '(Pedido Especial)'), ' - ', p.estado) SEPARATOR '; ') AS historial
    FROM clientes_totales c
    LEFT JOIN pedidos p ON c.id = p.cliente_id
    LEFT JOIN musica m ON p.tema = m.tema
    GROUP BY c.id";
$result_clientes_totales = $conn->query($sql_clientes_totales);

if (!$result_clientes_totales) {
    die("Error en la consulta SQL: " . $conn->error);
}
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Clientes Totales</title>
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-color: #f4f4f4;
            margin: 0;
            padding: 0;
        }
        .content-container {
            margin: 20px auto;
            width: 90%;
            max-width: 800px;
            background: white;
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
        }
        h2 {
            color: #0078D7;
            text-align: center;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        th, td {
            text-align: left;
            padding: 10px;
            border: 1px solid #ddd;
        }
        th {
            background-color: #0078D7;
            color: white;
        }
        .btn-export {
            background-color: #28a745;
            color: white;
            border: none;
            padding: 10px 15px;
            border-radius: 5px;
            cursor: pointer;
            margin-top: 20px;
            display: block;
            margin-left: auto;
            margin-right: auto;
        }
        .btn-export:hover {
            background-color: #218838;
        }
        .no-clientes {
            text-align: center;
            color: #666;
            margin-top: 20px;
        }
    </style>
</head>
<body>
    <?php include('cabecera.php'); ?>

    <div class="content-container">
        <h2>Clientes Totales</h2>

        <!-- Botón para exportar a Excel -->
        <form action="" method="post">
            <button type="submit" name="exportar_excel" class="btn-export">Exportar a Excel</button>
        </form>

        <!-- Tabla de clientes totales -->
        <?php if ($result_clientes_totales->num_rows > 0): ?>
            <table>
                <thead>
                    <tr>
                        <th>Nombre</th>
                        <th>Teléfono</th>
                        <th>Historial de Canciones</th>
                    </tr>
                </thead>
                <tbody>
                    <?php while ($row = $result_clientes_totales->fetch_assoc()): ?>
                        <tr>
                            <td><?php echo htmlspecialchars($row['nombre']); ?></td>
                            <td><?php echo htmlspecialchars($row['telefono']); ?></td>
                            <td><?php echo htmlspecialchars($row['historial']); ?></td>
                        </tr>
                    <?php endwhile; ?>
                </tbody>
            </table>
        <?php else: ?>
            <div class="no-clientes">No hay clientes totales registrados.</div>
        <?php endif; ?>
    </div>
</body>
</html>
