<?php
include('bd/db.php'); // Conexión a la base de datos

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id = intval($_POST['id']);
    $estado = trim($_POST['estado']);

    // Validar datos
    if (!empty($id) && in_array($estado, ['Tocado', 'Aceptado', 'No se toca'])) {
        // Actualizar estado en la base de datos
        $sql_update = "UPDATE pedidos SET estado = ? WHERE id = ?";
        $stmt = $conn->prepare($sql_update);
        $stmt->bind_param("si", $estado, $id);
        if ($stmt->execute()) {
            echo json_encode(['success' => true, 'message' => 'Estado actualizado correctamente.']);
            exit();
        } else {
            echo json_encode(['success' => false, 'message' => 'Error al actualizar el estado en la base de datos.']);
            exit();
        }
    } else {
        echo json_encode(['success' => false, 'message' => 'Datos inválidos.']);
    }
} else {
    echo json_encode(['success' => false, 'message' => 'Método no permitido.']);
}
