<?php
/**
 * @package    TGM-Plugin-Activation
 * @subpackage ProRadio
 **/

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Notification about remote connection used by remote.php
 */
if(!function_exists('proradio_bulletin_news')){

	function proradio_bulletin_news() {

		

		$dismissed = get_option( 'proradio-dismiss-news'.PRORADIO_VERSION, true );

		if($dismissed === '1'){
			return;
		}

		if(isset($_GET['proradio-dismiss-news'])){
			if('yes' === $_GET['proradio-dismiss-news']){
				update_option( 'proradio-dismiss-news'.PRORADIO_VERSION, '1' );
			}
		}

		if(isset($_GET['page'])){
			if('proradio-welcome' === $_GET['page']){
				return;
			}
		}


		$proradio_iid 			= proradio_iid();
		$stored_activation_key 	= get_option( 'proradio_ack_' . trim( $proradio_iid ) );
		$stored_license_key 	= get_option( 'proradio_licensekey_' . trim( $proradio_iid ) );

	

		if( $stored_activation_key && $stored_license_key ){
	
			?>
			<div class="notice notice-error proradio-welcome__notice is-dismissible">
				<img src="<?php echo esc_url( get_theme_file_uri( '/inc/tgm-plugin-activation/img/logo-news.png' ) ); ?>" alt="<?php esc_attr_e('Logo','firlw'); ?>">
				<h3>We have some news for you!</h3>
				<p>Find out more: <a href="<?php echo admin_url( 'themes.php?page=proradio-welcome&proradio-dismiss-news=yes' ); ?>">click here</a></p>
			</div>
			<?php
		}

	}


	add_action( 'admin_notices', 'proradio_bulletin_news' );
}