<?php
/**
 * @package WordPress
 * @subpackage proradio
 * @subpackage kirki
 * @version 1.0.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}


Kirki::add_field( 'proradio_config', array(
	'type'        => 'switch',
	'settings'    => 'show_social_offcanvas',
	'label'       => esc_html__( 'Display social in off-canvas sidebar', "proradio" ),
	'section'     => 'proradio_social_offcanvas',
	'default'       => 1,
	'priority'    => 1,
));



Kirki::add_field( 'proradio_config', [
	'type'        => 'slider',
	'settings'    => 'soc_icons_margin_offcanvas',
	'label'       => esc_html__( 'Margin', 'proradio' ),
	'section'     => 'proradio_social_offcanvas',
	'transport'   => 'auto',
	'default'       => 5,
	'choices'     => [
		'min'  => 0,
		'max'  => 20,
		'step' => 1
	],
	'output'    => array(
		array(
			'element'       => '.proradio-overlay__social > .proradio-soc-icon',
			'property'      => 'margin-right',
			'value_pattern' => esc_attr( ' $px;' ),
			'media_query' => '@media (min-width: 1200px)'
		),
		array(
			'element'       => '.proradio-overlay__social > .proradio-soc-icon',
			'property'      => 'margin',
			'value_pattern' => esc_attr( '0 $px $px 0;' ),
			'media_query' => '@media (max-width: 1199px)'
		),
	),
	'active_callback' => [
		[
			'setting'   => 'show_social_offcanvas',
			'operator'  => '==',
			'value'     => true,
		]
	],
] );


Kirki::add_field( 'proradio_config', [
	'type'        => 'slider',
	'settings'    => 'soc_icons_lh_offcanvas',
	'label'       => esc_html__( 'Line height', 'proradio' ),
	'section'     => 'proradio_social_offcanvas',
	'transport'   => 'auto',
	'choices'     => [
		'min'  => 0.1,
		'max'  => 6,
		'step' => 0.05
	],
	'output'    => array(
		array(
			'element'       => '.proradio-overlay__social .proradio-soc-icon',
			'property'      => 'line-height',
			'value_pattern' => esc_attr( ' $em !important;' ),
		),
	),
	'active_callback' => [
		[
			'setting'   => 'show_social_offcanvas',
			'operator'  => '==',
			'value'     => true,
		]
	],
] );


Kirki::add_field( 'proradio_config', [
	'type'        => 'dimensions',
	'settings'    => 'soc_icons_padding_offcanvas',
	'label'       => esc_html__( 'Padding', 'proradio' ),
	'section'     => 'proradio_social_offcanvas',
	'default'     => 0,
	'transport'   => 'auto',
	'default'     => [
		'padding-top'    => '0px',
		'padding-bottom' => '0px',
		'padding-left'   => '0px',
		'padding-right'  => '0px',
	],
	'output'      => array(
		array(
		  'choice'      => 'padding-top',
		  'element'     => '.proradio-overlay__social a.proradio-soc-icon',
		  'property'    => 'padding-top',
		),
		array(
		  'choice'      => 'padding-bottom',
		  'element'     => '.proradio-overlay__social a.proradio-soc-icon',
		  'property'    => 'padding-bottom',
		),
		array(
		  'choice'      => 'padding-left',
		  'element'     => '.proradio-overlay__social a.proradio-soc-icon',
		  'property'    => 'padding-left',
		),
		array(
		  'choice'      => 'padding-right',
		  'element'     => '.proradio-overlay__social a.proradio-soc-icon',
		  'property'    => 'padding-right',
		),
	),
	'active_callback' => [
		[
			'setting'   => 'show_social_offcanvas',
			'operator'  => '==',
			'value'     => true,
		]
	],

] );



/* Border */

Kirki::add_field( 'proradio_config', [
	'type'        => 'slider',
	'settings'    => 'soc_icons_bw_offcanvas',
	'label'       => esc_html__( 'Border', 'proradio' ),
	'section'     => 'proradio_social_offcanvas',
	'default'     => 0,
	'transport'   => 'auto',
	'choices'     => [
		'min'  => 0,
		'max'  => 10,
		'step' => 1
	],
	'output'    => array(
		array(
			'element'       => '.proradio-overlay__social .proradio-soc-icon',
			'property'      => 'border-width',
			'value_pattern' => esc_attr( ' $px;' ),
		),
	),
	'active_callback' => [
		[
			'setting'   => 'show_social_offcanvas',
			'operator'  => '==',
			'value'     => true,
		]
	],

] );
Kirki::add_field( 'proradio_config', [
	'type'        => 'slider',
	'settings'    => 'soc_icons_br_offcanvas',
	'label'       => esc_html__( 'Border radius', 'proradio' ),
	'section'     => 'proradio_social_offcanvas',
	'default'     => 0,
	'transport'   => 'auto',
	'choices'     => [
		'min'  => 0,
		'max'  => 50,
		'step' => 1
	],
	'output'    => array(
		array(
			'element'       => '.proradio-overlay__social .proradio-soc-icon',
			'property'      => 'border-radius',
			'value_pattern' => esc_attr( ' $px;' ),
		),
	),
	'active_callback' => [
		[
			'setting'   => 'show_social_offcanvas',
			'operator'  => '==',
			'value'     => true,
		]
	],

] );

/* = Main colors
=============================================*/
Kirki::add_field( 'proradio_config', array(
	'type'        => 'color',
	'settings'    => 'soc_icons_bg_offcanvas',
	'label'       => esc_html__( 'Background', "proradio" ),
	'section'     => 'proradio_social_offcanvas',
	'transport'   => 'auto',
	'choices'     => [
		'alpha' => true,
	],
	'output'    => array(
		array(
			'element'       => '.proradio-overlay__social a.proradio-soc-icon',
			'property'      => 'background-color',
		),
	),
	'active_callback' => [
		[
			'setting'   => 'show_social_offcanvas',
			'operator'  => '==',
			'value'     => true,
		]
	],
));
Kirki::add_field( 'proradio_config', array(
	'type'        => 'color',
	'settings'    => 'soc_icons_bg_h_offcanvas',
	'label'       => esc_html__( 'Background over', "proradio" ),
	'section'     => 'proradio_social_offcanvas',
	'transport'   => 'auto',
	'choices'     => [
		'alpha' => true,
	],
	'output'    => array(
		array(
			'element'       => '.proradio-overlay__social a.proradio-soc-icon:hover',
			'property'      => 'background-color',
		),
	),
	'active_callback' => [
		[
			'setting'   => 'show_social_offcanvas',
			'operator'  => '==',
			'value'     => true,
		]
	],
));

Kirki::add_field( 'proradio_config', array(
	'type'        => 'color',
	'settings'    => 'soc_icons_color_offcanvas',
	'label'       => esc_html__( 'Icon color', "proradio" ),
	'section'     => 'proradio_social_offcanvas',
	'transport'   => 'auto',
	'choices'     => [
		'alpha' => true,
	],
	'output'    => array(
		array(
			'element'       => '.proradio-overlay__social a.proradio-soc-icon',
			'property'      => 'color',
		),
	),
	'active_callback' => [
		[
			'setting'   => 'show_social_offcanvas',
			'operator'  => '==',
			'value'     => true,
		]
	],
));
Kirki::add_field( 'proradio_config', array(
	'type'        => 'color',
	'settings'    => 'soc_icons_color_h_offcanvas',
	'label'       => esc_html__( 'Icon color hover', "proradio" ),
	'section'     => 'proradio_social_offcanvas',
	'transport'   => 'auto',
	'choices'     => [
		'alpha' => true,
	],
	'output'    => array(
		array(
			'element'       => '.proradio-overlay__social a.proradio-soc-icon:hover',
			'property'      => 'color',
		),
	),
	'active_callback' => [
		[
			'setting'   => 'show_social_offcanvas',
			'operator'  => '==',
			'value'     => true,
		]
	],
));
