<?php
/**
 * @package WordPress
 * @subpackage proradio
 * @subpackage kirki
 * @version 1.0.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}



/**
 * Corner radius
 * ============================================================ */

Kirki::add_field( 'proradio_config', [
	'type'        => 'slider',
	'settings'    => 'items_pad_mob',
	'label'       => esc_html__( 'Post items content padding', 'proradio' ).' '.esc_html__( 'mobile', 'proradio' ),
	'description' => esc_html__( 'Affects the content padding of every card element', "proradio" ),
	'section'     => 'proradio_post_items_section',
	'transport'   => 'auto',
	'choices'     => [
		'min'  => 0,
		'max'  => 70,
		'step' => 1,
	],
	'output'    => array(
		array(
			'element'       => '.proradio-post__content',
			'property'      => 'padding',
			'value_pattern' => esc_attr( ' $px;' ),
			'media_query' => '@media (max-width: 1119px)'
		),


	),
] );



Kirki::add_field( 'proradio_config', [
	'type'        => 'slider',
	'settings'    => 'items_pad_des',
	'label'       => esc_html__( 'Post items content padding', 'proradio' ).' '.esc_html__( 'desktop', 'proradio' ),
	'description' => esc_html__( 'Affects the content padding of every card element', "proradio" ),
	'section'     => 'proradio_post_items_section',
	'transport'   => 'auto',
	'choices'     => [
		'min'  => 0,
		'max'  => 70,
		'step' => 1,
	],
	'output'    => array(
		array(
			'element'       => '.proradio-post__content',
			'property'      => 'padding',
			'value_pattern' => esc_attr( ' $px;' ),
			'media_query' => '@media (min-width: 1200px)'
		),


	),
] );




Kirki::add_field( 'proradio_config', [
	'type'        => 'slider',
	'settings'    => 'items_rad',
	'label'       => esc_html__( 'Post items corner radius', 'proradio' ),
	'description' => esc_html__( 'Affect border radius of every card element in the site for coherence', "proradio" ),
	'section'     => 'proradio_post_items_section',
	'default'     => 0,
	'transport'   => 'auto',
	'choices'     => [
		'min'  => 0,
		'max'  => 12,
		'step' => 1,
	],
	'output'    => array(
		array(
			'element'       => '.proradio-chart-tracklist .proradio-chart-track, .proradio-post, .proradio-bgimg, .proradio-post__header, .proradio-post__header .proradio-bgimg, .proradio-cards__content , .proradio-pricingtable__content, .proradio-pricingtable__pc::before, .proradio-card, .proradio-scard, .proradio-authorbox, .proradio-cat-card,  .blocks-gallery-item figure',
			'property'      => 'border-radius',
			'value_pattern' => esc_attr( ' $px;' ),
		),
		array(
			'element'       => '.proradio-videogalleries__item',
			'property'      => 'border-radius',
			'value_pattern' => esc_attr( ' $px;' ),
		),
		//bbpress
		array(
			'element' 		=> '.bbp-body, .bbp-form, img.avatar, .bbp-template-notice, #proradio-body fieldset.bbp-form legend, .proradio-bbpress--header, .bbp-forums, #bbp-user-wrapper, #proradio-body.woocommerce .proradio-master .woocommerce-tabs .panel, .woocommerce-product-gallery, #proradio-body.woocommerce .proradio-master .woocommerce-tabs ul.tabs.wc-tabs',
			'property'      => 'border-radius',
			'value_pattern' => esc_attr( ' $px;' ),
		)


	),
] );


Kirki::add_field( 'proradio_config', [
	'type'        => 'slider',
	'settings'    => 'items_shad',
	'label'       => esc_html__( 'Shadow', 'proradio' ),
	'section'     => 'proradio_post_items_section',
	'default'     => 0.5,
	'transport'   => 'auto',
	'choices'     => [
		'min'  => 0,
		'max'  => 1,
		'step' => 0.01,
	],
	'output'    => array(
		array(
			'element'       => '.proradio-post, #proradio-body a.proradio-cat-card, .proradio-videogalleries__item, .proradio-arrow',
			'property'      => 'box-shadow',
			'value_pattern' => '0 0 6px 0px rgba(0, 0, 0, $);',
		),
		//bbpress
		array(
			'element' 		=> '.bbp-body, .bbp-form, .proradio-bbpress--header, .bbp-forums, #bbp-user-wrapper',
			'property'      => 'box-shadow',
			'value_pattern' => '0 0 6px 0px rgba(0, 0, 0, $);',
		)
	),
] );





Kirki::add_field( 'proradio_config', [
	'type'        => 'slider',
	'settings'    => 'items_bg_grad',
	'label'       => esc_html__( 'Background gradient for texts', 'proradio' ),
	'description' => esc_html__( 'Set the opacity of the black background on top of the items to improve legibility', "proradio" ),
	'section'     => 'proradio_post_items_section',
	'default'     => 0.7,
	'transport'   => 'auto',
	'choices'     => [
		'min'  => 0,
		'max'  => 1,
		'step' => 0.01,
	],
	'output'    => array(
		array(
			'element'       => '.proradio-post__card .proradio-post__headercont, .proradio-post__hero .proradio-post__headercont, #proradio-body .proradio-master .proradio-slider__c',
			'property'      => 'background',
			'value_pattern' => esc_attr( 'linear-gradient(to bottom, rgba(0, 0, 0, 0) 0%, rgba(0, 0, 0, 0) 40%, rgba(0, 0, 0, $) 65%, rgba(0, 0, 0, $) 100%);' ),
		),
	),
] );

Kirki::add_field( 'proradio_config', [
	'type'        => 'slider',
	'settings'    => 'items_meta_fontsize',
	'label'       => esc_html__( 'Post meta information font size', 'proradio' ),
	'description' => esc_html__( 'Change size for small text as date, author and other secondary information', "proradio" ),
	'section'     => 'proradio_post_items_section',
	'transport'   => 'auto',
	'choices'     => [
		'min'  => 8,
		'max'  => 20,
		'step' => 1,
	],
	'output'    => array(
		array(
			'element'       => '.proradio-post .proradio-meta, .proradio-itemmetas',
			'property'      => 'font-size',
			'value_pattern' => esc_attr( ' $px' ),
		),
	),
] );

Kirki::add_field( 'proradio_config', [
	'type'        => 'slider',
	'settings'    => 'cats_fontsize',
	'label'       => esc_html__( 'Categories font size', 'proradio' ),
	'section'     => 'proradio_post_items_section',
	'transport'   => 'auto',
	'choices'     => [
		'min'  => 8,
		'max'  => 20,
		'step' => 1,
	],
	'output'    => array(
		array(
			'element'       => '.proradio-cats a',
			'property'      => 'font-size',
			'value_pattern' => esc_attr( ' $px' ),
		),
	),
] );


Kirki::add_field( 'proradio_config', array(
	'type'        => 'color',
	'settings'    => 'post_duotone_c1',
	'label'       => esc_html__( 'Hover duotone color light', "proradio" ),
	'description' => esc_html__( 'To disable set color white', "proradio" ),
	'section'     => 'proradio_post_items_section',
	'priority'    => 10,
	'output'    => array(
		array(
			'element'       => '.proradio-post .proradio-duotone::before',
			'property'      => 'background-color',
		),
	),
));
Kirki::add_field( 'proradio_config', array(
	'type'        => 'color',
	'settings'    => 'post_duotone_c2',
	'label'       => esc_html__( 'Hover duotone color dark', "proradio" ),
	'description' => esc_html__( 'To disable set color black', "proradio" ),
	'section'     => 'proradio_post_items_section',
	'priority'    => 10,
	'output'    => array(
		array(
			'element'       => '.proradio-post .proradio-duotone::after',
			'property'      => 'background-color',
		),
	),
));

