<?php
/**
 * @package WordPress
 * @subpackage proradio
 * @subpackage kirki
 * @version 1.0.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

Kirki::add_field( 'proradio_config', [
	'type'        => 'custom',
	'settings'    => 'headerbg-section-alignment',
	'section'     => 'proradio_pageheader_section',
	'priority' => 10,
	'default'     => '<h2 class="proradio-kirki-sectioncaption">'.esc_html__('Header alignment', 'proradio').'</h2>',
] );
// Template
Kirki::add_field( 'proradio_config', array(
	'type'      => 'select',
	'settings'  => 'pageheader_align',
	'label'     => esc_html__( 'Content alignment', 'proradio' ),
	'section'   => 'proradio_pageheader_section',
	'multiple'    => false,
	// 'default'	=> '',
	'transport'   => 'auto',
	'choices'   => array(
		'center'   => esc_attr__( 'Center', 'proradio' ),
		'left' 	=> esc_attr__( 'Left', 'proradio' ), // double is part of the css class, do not change
		'right' 	=> esc_attr__( 'right', 'proradio' ),
	),
	'output'    => array(
		array(
			'element'       => '.proradio-pageheader__contents',
			'property'      => 'text-align',
		),
		array(
			'element'       => '.proradio-pageheader .proradio-decor',
			'property'      => 'float',
		),
	)
		
));


/**
 * =======================================================================
 * Captions
 * =======================================================================
 * */


Kirki::add_field( 'proradio_config', [
	'type'        => 'custom',
	'settings'    => 'headerbg-section-caption',
	'section'     => 'proradio_pageheader_section',
	'priority' => 10,
	'default'     => '<h2 class="proradio-kirki-sectioncaption">'.esc_html__('Header captions', 'proradio').'</h2>',
] );
Kirki::add_field( 'proradio_config', [
	'type'        => 'slider',
	'settings'    => 'pageheader_capsize',
	'label'       => esc_html__( 'Caption size', 'proradio' ),
	'description' => esc_html__( 'Desktop', "proradio" ),
	'section'     => 'proradio_pageheader_section',
	'default'     => 3.05,
	'transport'   => 'auto',
	'choices'     => [
		'min'  => 2,
		'max'  => 7,
		'step' => 0.1
	],
	'output'    => array(
		array(
			'element'       => '.proradio-pageheader__contents .proradio-pagecaption',
			'property'      => 'font-size',
			'value_pattern' => esc_attr( ' $em;' ),
			'media_query' => '@media (min-width: 1200px)'
		),
	),

] );

Kirki::add_field( 'proradio_config', [
	'type'        => 'slider',
	'settings'    => 'pageheader_capsize_m',
	'label'       => esc_html__( 'Caption size', 'proradio' ),
	'description' => esc_html__( 'Mobile', "proradio" ),
	'section'     => 'proradio_pageheader_section',
	'transport'   => 'auto',
	'default'     => 1.802,
	'choices'     => [
		'min'  => 2,
		'max'  => 7,
		'step' => 0.1
	],
	'output'    => array(
		array(
			'element'       => '.proradio-pageheader__contents .proradio-pagecaption',
			'property'      => 'font-size',
			'value_pattern' => esc_attr( ' $em;' ),
			'media_query' => '@media (max-width: 670px)'
		),
	),

] );


/**
 * =======================================================================
 * Spacing
 * =======================================================================
 * */


Kirki::add_field( 'proradio_config', [
	'type'        => 'custom',
	'settings'    => 'headerbg-section-spacing',
	'section'     => 'proradio_pageheader_section',
	'priority' => 10,
	'default'     => '<h2 class="proradio-kirki-sectioncaption">'.esc_html__('Spacing and padding', 'proradio').'</h2>',
] );


// Page header padding =============================
Kirki::add_field( 'proradio_config', [
	'type'        => 'slider',
	'settings'    => 'pageheader_paddingh_m',
	'label'       => esc_html__( 'Padding horizontal mobile', 'proradio' ),
	'section'     => 'proradio_pageheader_section',
	'transport'   => 'auto',
	'choices'     => [
		'min'  => 0,
		'max'  => 50,
		'step' => 1,
	],
	'output'    => array(
		array(
			'element'       => '.proradio-pageheader__contents .proradio-container',
			'property'      => 'padding-right',
			'value_pattern' => esc_attr( ' $px;' ),
			'media_query' => '@media (max-width: 670px)'
		),
		array(
			'element'       => '.proradio-pageheader__contents .proradio-container',
			'property'      => 'padding-left',
			'value_pattern' => esc_attr( ' $px;' ),
			'media_query' => '@media (max-width: 670px)'
		),
	),
] );

// Page header padding =============================
Kirki::add_field( 'proradio_config', [
	'type'        => 'slider',
	'settings'    => 'pageheader_paddingh',
	'label'       => esc_html__( 'Padding horizontal', 'proradio' ),
	'section'     => 'proradio_pageheader_section',
	'transport'   => 'auto',
	'choices'     => [
		'min'  => 0,
		'max'  => 50,
		'step' => 1,
	],
	'output'    => array(
		array(
			'element'       => '.proradio-pageheader__contents .proradio-container',
			'property'      => 'padding-right',
			'value_pattern' => esc_attr( ' $px;' ),
			'media_query' => '@media (min-width: 671px)'
		),
		array(
			'element'       => '.proradio-pageheader__contents .proradio-container',
			'property'      => 'padding-left',
			'value_pattern' => esc_attr( ' $px;' ),
			'media_query' => '@media (min-width: 671px)'
		),
	),
] );







// Page header padding =============================
Kirki::add_field( 'proradio_config', [
	'type'        => 'slider',
	'settings'    => 'proradio_headerpadding_top',
	'label'       => esc_html__( 'Padding top', 'proradio' ),
	'section'     => 'proradio_pageheader_section',
	'default'     => 160,
	'transport'   => 'auto',
	'choices'     => [
		'min'  => 40,
		'max'  => 400,
		'step' => 10,
	],
	'output'    => array(
		array(
			'element'       => '.proradio-pageheader__contents',
			'property'      => 'padding-top',
			'value_pattern' => esc_attr( ' $px;' ),
			// 'media_query' => '@media (min-width: 600px)'
		),
	),
] );

Kirki::add_field( 'proradio_config', [
	'type'        => 'slider',
	'settings'    => 'proradio_headerpadding_bottom',
	'label'       => esc_html__( 'Padding bottom', 'proradio' ),
	'section'     => 'proradio_pageheader_section',
	'default'     => 140,
	'transport'   => 'auto',
	'choices'     => [
		'min'  => 40,
		'max'  => 400,
		'step' => 10,
	],
	'output'    => array(
		array(
			'element'       => '.proradio-pageheader__contents',
			'property'      => 'padding-bottom',
			'value_pattern' => esc_attr( ' $px;' ),
			// 'media_query' => '@media (min-width: 600px)'
		),
	),
] );


Kirki::add_field( 'proradio_config', [
	'type'        => 'slider',
	'settings'    => 'proradio_headerpadding_mobile',
	'label'       => esc_html__( 'Mobile padding', 'proradio' ),
	'section'     => 'proradio_pageheader_section',
	'default'     => 50,
	'transport'   => 'auto',
	'choices'     => [
		'min'  => 20,
		'max'  => 150,
		'step' => 5,
	],
	'output'    => array(
		array(
			'element'       => '.proradio-pageheader__contents',
			'property'      => 'padding-bottom',
			'value_pattern' => esc_attr( ' $px;' ),
			'media_query' => '@media (max-width: 600px)'
		),
		array(
			'element'       => '.proradio-pageheader__contents',
			'property'      => 'padding-top',
			'value_pattern' => esc_attr( ' $px;' ),
			'media_query' => '@media (max-width: 600px)'
		),
	)
] );

Kirki::add_field( 'proradio_config', [
	'type'        => 'slider',
	'settings'    => 'proradio_headerpadding_mobile_b',
	'label'       => esc_html__( 'Mobile padding bottom', 'proradio' ),
	'section'     => 'proradio_pageheader_section',
	'default'     => 50,
	'transport'   => 'auto',
	'choices'     => [
		'min'  => 20,
		'max'  => 150,
		'step' => 5,
	],
	'output'    => array(
		array(
			'element'       => '.proradio-pageheader__contents',
			'property'      => 'padding-bottom',
			'value_pattern' => esc_attr( ' $px;' ),
			'media_query' => '@media (max-width: 600px)'
		),
	)
] );



/**
 * =======================================================================
 * Effects and decorations
 * =======================================================================
 * */




Kirki::add_field( 'proradio_config', [
	'type'        => 'custom',
	'settings'    => 'headerbg-section-fx',
	'section'     => 'proradio_pageheader_section',
	'priority' => 10,
	'default'     => '<h2 class="proradio-kirki-sectioncaption">'.esc_html__('Effects and decorations', 'proradio').'</h2>',
] );


Kirki::add_field( 'proradio_config', array(
	'type'        => 'switch',
	'settings'    => 'header_3d_effect',
	'label'       => esc_html__( '3D header animation', "proradio" ),
	'default'     => '0',
	'section'     => 'proradio_pageheader_section',
	'priority'    => 10,
));


if ( ! function_exists( 'proradio_header_3d_effect_class' ) ) {
	add_filter('body_class', 'proradio_header_3d_effect_class');	
	function proradio_header_3d_effect_class($classes){
		if( get_theme_mod( 'header_3d_effect')  ){
			$classes[] =  esc_attr( 'proradio-fx-3dheader' );
		}
		return $classes;
	}
}



Kirki::add_field( 'proradio_config', array(
	'type'        => 'switch',
	'settings'    => 'proradio_header_waves',
	'label'       => esc_html__( 'Waves effect', "proradio" ),
	'default'     => '0',
	'section'     => 'proradio_pageheader_section',
	'priority'    => 10,
));

Kirki::add_field( 'proradio_config', array(
	'type'        => 'color',
	'settings'    => 'wave_front_color',
	'label'       => esc_html__( 'Front wave color', "proradio" ),
	'section'     => 'proradio_pageheader_section',
	'priority'    => 10,
	'active_callback' => [
		[
			'setting'  => 'proradio_header_waves',
			'operator' => '==',
			'value'    => '1',
		]
	],
));

Kirki::add_field( 'proradio_config', array(
	'type'        => 'color',
	'settings'    => 'wave_back_color',
	'label'       => esc_html__( 'Background wave color', "proradio" ),
	'section'     => 'proradio_pageheader_section',
	'priority'    => 10,
	'active_callback' => [
		[
			'setting'  => 'proradio_header_waves',
			'operator' => '==',
			'value'    => '1',
		]
	],
));

Kirki::add_field( 'proradio_config', array(
	'type'        => 'switch',
	'settings'    => 'mousescroll',
	'label'       => esc_html__( 'Mouse icon', "proradio" ),
	'section'     => 'proradio_pageheader_section',
	'priority'    => 10,
	'default'     => '1'
));

Kirki::add_field( 'proradio_config', array(
	'type'        => 'select',
	'settings'    => 'header_decor',
	'label'       => esc_html__( 'Header decoration', 'proradio' ),
	'section'     => 'proradio_pageheader_section',
	'default'     => 'none',
	'priority'    => 10,
	'multiple'    => false,
	'choices'     => array(
			'none' 	=> esc_attr__( 'None', 'proradio' ),
			'default'   	=> esc_attr__( 'Default', 'proradio' ),
			
		)
) );




Kirki::add_field( 'proradio_config', [
	'type'        => 'custom',
	'settings'    => 'headerbg-section-frame',
	'section'     => 'proradio_pageheader_section',
	'priority' => 10,
	'default'     => '<h2 class="proradio-kirki-sectioncaption">'.esc_html__('Frame border', 'proradio').'</h2>',
] );
Kirki::add_field( 'proradio_config', [
	'type'        => 'slider',
	'settings'    => 'header_frame',
	'label'       => esc_html__( 'Frame border width', 'proradio' ),
	'section'     => 'proradio_pageheader_section',
	'default'     => 0,
	'transport'   => 'auto',
	'choices'     => [
		'min'  => 0,
		'max'  => 15,
		'step' => 1,
	],
	'output'    => array(
		array(
			'element'       => '.proradio-pageheader__contents .proradio-container',
			'property'      => 'border-width',
			'value_pattern' => esc_attr( ' $px;' ),
		),
	),
] );

Kirki::add_field( 'proradio_config', array(
	'type'        => 'color',
	'settings'    => 'header_frame_color',
	'label'       => esc_html__( 'Page header frame color', "proradio" ),
	'section'     => 'proradio_pageheader_section',
	'transport'   => 'auto',
	'priority'    => 10,
	'output'    => array(
		array(
			'element'       => '.proradio-pageheader__contents .proradio-container',
			'property'      => 'border-color',
		)
	),
));


Kirki::add_field( 'proradio_config', [
	'type'        => 'slider',
	'settings'    => 'header_frame_pad',
	'label'       => esc_html__( 'Frame padding', 'proradio' ),
	'section'     => 'proradio_pageheader_section',
	'default'     => 0,
	'transport'   => 'auto',
	'choices'     => [
		'min'  => 0,
		'max'  => 150,
		'step' => 10,
	],
	'output'    => array(
		array(
			'element'       => '.proradio-pageheader__contents .proradio-container',
			'property'      => 'padding-top',
			'value_pattern' => esc_attr( ' $px;' ),
		),
		array(
			'element'       => '.proradio-pageheader__contents .proradio-container',
			'property'      => 'padding-bottom',
			'value_pattern' => esc_attr( ' $px;' ),
		),
	),
] );



/**
 * =======================================================================
 * Background
 * =======================================================================
 * */

Kirki::add_field( 'proradio_config', [
	'type'        => 'custom',
	'settings'    => 'headerbg-section-text',
	'section'     => 'proradio_pageheader_section',
	'priority' => 10,
	'default'     => '<h2 class="proradio-kirki-sectioncaption">'.esc_html__('Header background', 'proradio').'</h2>',
] );

Kirki::add_field( 'proradio_config', array(
	'type'        => 'image',
	'settings'    => 'proradio_header_bgimg',
	'label'       => esc_html__( 'Default page header background image', "proradio" ),
	'description' => esc_html__( 'Suggested size: 1660x790', "proradio" ),
	'section'     => 'proradio_pageheader_section',
	'priority'    => 10,
	'choices'     => array(
		'save_as' => 'id',
	),
));

Kirki::add_field( 'proradio_config', [
	'type'        => 'slider',
	'settings'    => 'pageheader_img_alpha',
	'label'       => esc_html__( 'Background picture opacity', 'proradio' ),
	'section'     => 'proradio_pageheader_section',
	'transport'   => 'auto',
	'default'     => 1,
	'choices'     => [
		'min'  => 0,
		'max'  => 1,
		'step' => 0.05
	],
	'output'    => array(
		array(
			'element'       => '.proradio-pageheader .proradio-bgimg',
			'property'      => 'opacity',
		),
	),

] );

Kirki::add_field( 'proradio_config', array(
	'type'        => 'switch',
	'settings'    => 'proradio_header_duotone',
	'label'       => esc_html__( 'Duotone effect on single pages header images', "proradio" ),
	'section'     => 'proradio_pageheader_section',
	'description' => esc_html__( 'Use the duotone effect on the page header. The colors are available in the Colors section of the customizer.', "proradio" ),
	'priority'    => 10,
	'default'     => '1'
));


Kirki::add_field( 'proradio_config', array(
	'type'        => 'color',
	'settings'    => 'proradio_header_textcolors',
	'label'       => esc_html__( 'Page header text colors', "proradio" ),
	'section'     => 'proradio_pageheader_section',
	'transport'   => 'auto',
	'priority'    => 10,
	'output'    => array(
		array(
			'element'       => '.proradio-pageheader .proradio-pageheader__contents p, .proradio-pageheader .proradio-pageheader__contents a, .proradio-pageheader .proradio-pageheader__contents h1',
			'property'      => 'color',
		),
		array(
			'element'       => '.proradio-mscroll__mouse, .proradio-mscroll__arrows, .proradio-mscroll__wheel',
			'property'      => 'border-color',
		),
	),
));

Kirki::add_field( 'proradio_config', array(
	'type'        => 'color',
	'settings'    => 'proradio_pageheader_bg',
	'label'       => esc_html__( 'Background color', "proradio" ),
	'section'     => 'proradio_pageheader_section',
	'priority'    => 10,
	'transport'   => 'auto',
	'choices'     => [
		'alpha' => true,
	],
	'output'		=> array(
		array(
			'element' => '.proradio-pageheader',
			'property'=>'background-color'
		)
	)
));




Kirki::add_field( 'proradio_config', array(
	'type'        => 'color',
	'settings'    => 'proradio_header_duotone_c1',
	'label'       => esc_html__( 'Duotone color light', "proradio" ),
	'description' => esc_html__( 'Requires the activation of duotone effect', "proradio" ),
	'section'     => 'proradio_pageheader_section',
	'default'	  => '#ff0056',
	'priority'    => 10,
	'output'    => array(
		array(
			'element'       => '.proradio-duotone::before',
			'property'      => 'background-color',
		),
	),
));
Kirki::add_field( 'proradio_config', array(
	'type'        => 'color',
	'settings'    => 'proradio_header_duotone_c2',
	'label'       => esc_html__( 'Duotone color dark', "proradio" ),
	'description' => esc_html__( 'Requires the activation of duotone effect', "proradio" ),
	'section'     => 'proradio_pageheader_section',
	'default'	  => '#053b6a',
	'priority'    => 10,
	'output'    => array(
		array(
			'element'       => '.proradio-duotone::after',
			'property'      => 'background-color',
		),
	),
));



Kirki::add_field( 'proradio_config', [
	'type'        => 'slider',
	'settings'    => 'proradio_header_greyscale',
	'label'       => esc_html__( 'Greyscale background', 'proradio' ),
	'description' => esc_html__( 'Remove colors from header background for neat effect', "proradio" ),
	'section'     => 'proradio_pageheader_section',
	'default'     => 73,
	'transport'   => 'auto',
	'choices'     => [
		'min'  => 0,
		'max'  => 100,
		'step' => 1,
	],
	'output'    => array(
		array(
			'element'       => '.proradio-pageheader .proradio-bgimg.proradio-greyscale',
			'property'      => 'filter',
			'value_pattern' => esc_attr( ' contrast(1.2) grayscale($%);' ),
		),
	),
] );



Kirki::add_field( 'proradio_config', [
	'type'        => 'slider',
	'settings'    => 'proradio_header_darken',
	'label'       => esc_html__( 'Darken background', 'proradio' ),
	'section'     => 'proradio_pageheader_section',
	'default'     => 0.6,
	'transport'   => 'auto',
	'choices'     => [
		'min'  => 0,
		'max'  => 1,
		'step' => 0.1,
	],
	'output'    => array(
		array(
			'element'       => '.proradio-dark-layer',
			'property'      => 'opacity',
			'value_pattern' => esc_attr( ' $;' ),
		),
	),
] );


Kirki::add_field( 'proradio_config', [
	'type'        => 'slider',
	'settings'    => 'proradio_header_gradlayer_alfa',
	'label'       => esc_html__( 'Gradient overlay', 'proradio' ),
	'section'     => 'proradio_pageheader_section',
	'default'     => 0.9,
	'transport'   => 'auto',
	'choices'     => [
		'min'  => 0,
		'max'  => 1,
		'step' => 0.1,
	],
	'output'    => array(
		array(
			'element'       => '.proradio-pageheader .proradio-grad-layer',
			'property'      => 'opacity',
			'value_pattern' => esc_attr( ' $;' ),
		),
	),
] );



Kirki::add_field( 'proradio_config', [
	'type'        => 'multicolor',
	'settings'    => 'gradient_overlay',
	'label'       => esc_html__( 'Gradient overlay', 'proradio' ),
	'section'     => 'proradio_pageheader_section',
	'priority'    => 10,
	'choices'     => [
		'start'    => esc_html__( 'Color', 'proradio' ),
		'end'   => esc_html__( 'Hover', 'proradio' ),
	],
	'default'     => [
		'start'    => '#ff0062',
		'end'   => '#be024a',
	],
] );




Kirki::add_field( 'proradio_config', [
	'type'        => 'multicolor',
	'settings'    => 'gradient_overlay',
	'label'       => esc_html__( 'Gradient overlay', 'proradio' ),
	'section'     => 'proradio_pageheader_section',
	'priority'    => 10,
	'choices'     => [
		'start'    => esc_html__( 'Start', 'proradio' ),
		'end'   => esc_html__( 'End', 'proradio' ),
	],
	'default'     => [
		'start'    => '#e01c67',
		'end'   => '#b70135',
	],
] );



Kirki::add_field( 'proradio_config', [
	'type'        => 'custom',
	'settings'    => 'headerbg-section-parallax',
	'section'     => 'proradio_pageheader_section',
	'priority' => 10,
	'default'     => '<h2 class="proradio-kirki-sectioncaption">'.esc_html__('Parallax', 'proradio').'</h2>',
] );


Kirki::add_field( 'proradio_config', array(
	'type'        => 'switch',
	'settings'    => 'proradio_header_parallax',
	'label'       => esc_html__( 'Page header parallax', "proradio" ),
	'section'     => 'proradio_pageheader_section',
	'description' => esc_html__( 'Enable effect on scroll for archive and default headers', "proradio" ),
	'priority'    => 10,
	'default'     => '0'
));

// Parallax ratio
Kirki::add_field( 'proradio_config', [
	'type'        => 'slider',
	'settings'    => 'stellar_ratio',
	'label'       => esc_html__( 'Parallax speed', 'proradio' ),
	'section'     => 'proradio_pageheader_section',
	'default'     => 0.6,
	'transport'   => 'auto',
	'choices'     => [
		'min'  => 0,
		'max'  => 1,
		'step' => 0.02,
	],
] );

Kirki::add_field( 'proradio_config', [
	'type'        => 'slider',
	'settings'    => 'stellar_offset',
	'label'       => esc_html__( 'Parallax offset', 'proradio' ),
	'description' => esc_html__( 'Set this to match the menu height in case of empty background', "proradio" ),
	'section'     => 'proradio_pageheader_section',
	'default'     => 0,
	'transport'   => 'auto',
	'choices'     => [
		'min'  => -300,
		'max'  => 300,
		'step' => 1,
	],
] );

Kirki::add_field( 'proradio_config', [
	'type'        => 'slider',
	'settings'    => 'stellar_oversize',
	'label'       => esc_html__( 'Parallax image oversize', 'proradio' ),
	'description' => esc_html__( 'Increase image size for bigger motion effect', "proradio" ),
	'section'     => 'proradio_pageheader_section',
	'default'     => 100,
	'transport'   => 'auto',
	'choices'     => [
		'min'  => 100,
		'max'  => 300,
	],
	'output'    => array(
		array(
			'element'       => '.proradio-bgimg__parallax > img',
			'property'      => 'min-height',
			'value_pattern' => esc_attr( ' $%;' ),
		),
	),

] );
