<?php
/**
 * @package WordPress
 * @subpackage proradio
 * @subpackage kirki
 * @version 1.0.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}


/**
 * Layout
 * ============================================================ */
Kirki::add_field( 'proradio_config', [
	'type'        => 'slider',
	'settings'    => 'layout_width',
	'label'       => esc_html__( 'Maximum width', 'proradio' ),
	'description' => esc_html__( 'maximum width of the external container', "proradio" ),
	'section'     => 'proradio_layout_section',
	'default'     => 3000,
	'transport'   => 'auto',
	'choices'     => [
		'min'  => 1260,
		'max'  => 6000,
		'step' => 10,
	],
	'output'    => array(
		array(
			'element'       => '.proradio-master, .proradio-headerbar__content, .proradio-global, .qtmplayer__playlistcontainer',
			'property'      => 'max-width',
			'value_pattern' => esc_attr( ' $px;' ),
			'media_query' => '@media (min-width: 1200px)'
		),
		array(
			'element'       => '.proradio-menu__cont, .qtmplayer__controls, .proradio-secondaryhead__cont, .proradio-breadcrumb__list',
			'property'      => 'max-width',
			'value_pattern' => esc_attr( ' $px;' ),
			'media_query' => '@media (min-width: 1200px)'
		),

		
	),
] );

/*Kirki::add_field( 'proradio_config', [
	'type'        => 'slider',
	'settings'    => 'layout_menu_width',
	'label'       => esc_html__( 'Maximum width', 'proradio' ),
	'description' => esc_html__( 'maximum width of the external container', "proradio" ),
	'section'     => 'proradio_layout_section',
	'default'     => 3000,
	'transport'   => 'auto',
	'choices'     => [
		'min'  => 1260,
		'max'  => 5000,
		'step' => 10,
	],
	'output'    => array(
		array(
			'element'       => '.proradio-menu__cont, .proradio-secondaryhead__cont, .proradio-menu__cont, .proradio-breadcrumb__list',
			'property'      => 'max-width',
			'value_pattern' => esc_attr( ' $px;' ),
			'media_query' => '@media (min-width: 1200px)'
		),		
	),
] );
*/

Kirki::add_field( 'proradio_config', [
	'type'        => 'slider',
	'settings'    => 'layout_container_shadow',
	'label'       => esc_html__( 'Container shadow', 'proradio' ),
	'section'     => 'proradio_layout_section',
	'default'     => 0.5,
	'transport'   => 'auto',
	'choices'     => [
		'min'  => 0,
		'max'  => 1,
		'step' => 0.05,
	],
	'output'    => array(
		array(
			'element'       => '.proradio-global',
			'property'      => 'box-shadow',
			'value_pattern' => esc_attr( ' 0px 0px 20px 0px rgba(0,0,0,$); ' ),
		),
	),
] );

/**
 * Load more
 * ============================================================ */
Kirki::add_field( 'proradio_config', array(
	'type'        => 'switch',
	'settings'    => 'proradio_loadmore',
	'label'       => esc_html__( 'Load more', "proradio" ),
	'section'     => 'proradio_layout_section',
	'description' => esc_html__( 'Replace pagination with a load more button', "proradio" ),
	'priority'    => 10,
));


/**
 * Blog post sidebar
 * ============================================================ */
Kirki::add_field( 'proradio_config', array(
	'type'        => 'switch',
	'settings'    => 'proradio_postsidebar',
	'label'       => esc_html__( 'Blog post sidebar', "proradio" ),
	'section'     => 'proradio_layout_section',
	'description' => esc_html__( 'Enable sidebar in single posts. Does not affect other post types.', "proradio" ),
	'priority'    => 10,
));

/**
 * Blog post ajax comment form submit
 * ============================================================ */
Kirki::add_field( 'proradio_config', array(
	'type'        => 'switch',
	'settings'    => 'ajax_comments',
	'label'       => esc_html__( 'Ajax comments form', "proradio" ),
	'section'     => 'proradio_layout_section',
	'description' => esc_html__( 'Submit comments without reloading the page', "proradio" ),
	'priority'    => 10,
));

Kirki::add_field( 'proradio_config', array(
	'type'        => 'select',
	'settings'    => 'archive_template',
	'label'       => esc_html__( 'Archives template', 'proradio' ),
	'description' => esc_html__( 'Set default tempalte for blog archives', "proradio" ),
	'section'     => 'proradio_layout_section',
	'default'     => 'archive-sidebar',
	'priority'    => 10,
	'multiple'    => false,
	'choices'     => array(
			'archive-sidebar' 	=> esc_attr__( 'Default: archive sidebar', 'proradio' ),
			'archive-no-sidebar' 	=> esc_attr__( 'Archive no sidebar', 'proradio' ),
			'archive-grid-sidebar' 	=> esc_attr__( 'Grid sidebar', 'proradio' ),
			'archive-grid' 	=> esc_attr__( 'Grid no sidebar', 'proradio' ),
			'archive-horizontal' 	=> esc_attr__( 'Horizontal sidebar', 'proradio' ),
			'archive-masonry' 	=> esc_attr__( 'Masonry', 'proradio' ),
		)
) );





