<?php
/**
 * @package WordPress
 * @subpackage proradio
 * @version 1.0.0
*/

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

function proradio_custom_related($posttype){
	if(!$posttype){
		return;
	}
	$custom_related = array(
		array( // Repeatable & Sortable Text inputs
			'label'	=> esc_html__('Related',"proradio"), // <label>
			'desc'	=> esc_html__('Manually pick related items',"proradio"), // description
			'id'	=> 'custom_related_posts', // field id and name
			'type'	=> 'repeatable', // type of field
			'sanitizer' => array( // array of sanitizers with matching kets to next array
				'featured' => 'meta_box_santitize_boolean',
				'title' => 'sanitize_text_field',
				'desc' => 'wp_kses_data'
			),
			'repeatable_fields' => array ( // array of fields to be repeated
				array(
					'label' => esc_html__("Choose a related content","proradio"),
					'id'	=> 'custom_related_posts', // field id and name
					'type' => 'post_chosen',
					'posttype' =>  $posttype
				)
			)
		)
	);
	if(class_exists("Custom_Add_Meta_Box")){
		$custom_related = new Custom_Add_Meta_Box( 'custom_related', esc_html__('Custom related posts','proradio'), $custom_related, $posttype, true );
	}
}
