<?php

require_once(_PS_MODULE_DIR_."flowpaymentwp/lib/flowapiwp.php");
class FlowPaymentWPReturnModuleFrontController extends ModuleFrontController{

    public function __construct(){
        parent::__construct();
    }

    public function postProcess(){

        Logger::addLog('Entering the return callback... with params: '.json_encode($_POST));

        try{
            
            $token = Tools::getValue('token');

            if(empty($token)){
                throw new Exception('Token not received.');
            }
            
            $apiKey = Configuration::get('FLOW_WP_API_KEY');
            $secretKey = Configuration::get('FLOW_WP_SECRET_KEY');
            $mode = Configuration::get('FLOW_WP_MODE');
            $endpoint = $mode == 'TEST' ? 'https://sandbox.flow.cl/api' : 'https://www.flow.cl/api';
            $service = 'payment/getStatus';
            $method = 'GET';
            $params = array(
                'token' => $token
            );
            $flowApi = new FlowApiWP($apiKey, $secretKey, $endpoint);
           
            $result = $flowApi->send($service, $params, $method);
            Logger::addLog('Flow result: '.json_encode($result));

            $status = $result['status'];
            
            $currency = $this->context->currency;
            
            $order = new Order((int) $result['commerceOrder']);
            $customer = $order->getCustomer();
            $cart = new Cart(Cart::getCartIdByOrderId($order->id)); 
            
            if($this->userCanceledPayment($status, $result)){
                Logger::addLog('The user canceled the payment. Redirecting back to checkout...');
                $this->restoreCart($order->id);
                Tools::redirect('index.php?controller=order');
            }

            /*if($this->isTesting($result)){
                Logger::addLog('Setting up the simulation...');
                $this->setProductionEnvSimulation($status, $result);
            }*/
            
            //IF the order is valid, it means that it was created and has a valid status.
            if($order->valid || $order->getCurrentState() == Configuration::get('FLOW_PAYMENT_PENDING'))
            {
                
                if($this->userGeneratedCoupon($status, $result)){

                    Logger::addLog('User generated a coupon...');

                    if(!$this->isWebpay($result) && !empty(Configuration::get('FLOW_WP_URL_RETURN'))){
                        Tools::redirect(Configuration::get('FLOW_WP_URL_RETURN'));
                    }

                    Tools::redirect($this->context->link->getModuleLink('flowpaymentwp', 'coupon', array()));
                }
            }
            else{
                $this->restoreCart($order->id);
            }
            
            //Redirecting to the final page to show the result to the user.
            Tools::redirect('index.php?controller=order-confirmation&id_cart=' . $cart->id . '&id_module=' . (int)$this->module->id . '&id_order=' . $order->id . '&key=' . $cart->secure_key);
            
        }catch(\Exception $e){
            Logger::addLog('There has been an unexpected error: '.$e->getCode(). ' - '.$e->getMessage());
            Tools::redirect($this->context->link->getModuleLink('flowpaymentwp', 'error', array()));
        }
        
    }

    private function isPendingInFlow($status){
        return $status == 1;
    }

    private function isPaidInFlow($status){
        return $status == 2;
    }

    private function isRejectedInFlow($status){
        return $status == 3;
    }

    private function isCancelledInFlow($status){
        return $status == 4;
    }

    private function userCanceledPayment($status, $flowPaymentData){
        return $this->isPendingInFlow($status)
        && empty($flowPaymentData['paymentData']['media'])
        && empty($flowPaymentData['pending_info']['media']);
    }

    private function userGeneratedCoupon($status, $flowPaymentData){
        return $this->isPendingInFlow($status)
        && !empty($flowPaymentData['pending_info']['media']
        && empty($flowPaymentData['paymentData']['media']));
    }

    private function isWebpay($flowPaymentData){
        return (strtolower($this->module->getPaymentMediumName()) == 'webpay') || (strtolower($flowPaymentData['paymentData']['media']) == 'webpay');
    }

    private function isTesting($flowPaymentData){

        return ( Configuration::get('FLOW_WP_MODE') == 'TEST'
                 && ($flowPaymentData['paymentData']['media'] == 'Multicaja' 
                 || $flowPaymentData['paymentData']['media'] == 'Servipag')
                );
    }

    private function setProductionEnvSimulation(&$status, & $flowPaymentData){
        $status = 1;
        $flowPaymentData['pending_info']['media'] = $flowPaymentData['paymentData']['media'];
        $flowPaymentData['paymentData']['media'] = '';
    }
    
    private function restoreCart($orderId){
        
        Logger::addLog('Restoring cart...');
        $cart = new Cart(Cart::getCartIdByOrderId($orderId));
        $cartDuplicate = $cart->duplicate();
        $this->context->cookie->id_cart = $cartDuplicate['cart']->id;
        $context = $this->context;
        $context->cart = $cartDuplicate['cart'];
        CartRule::autoAddToCart($context);
        $this->context->cookie->write();
    }
}