<?php

require_once(_PS_MODULE_DIR_."flowpaymentwp/lib/flowapiwp.php");
class FlowPaymentWPConfirmationModuleFrontController extends ModuleFrontController{

    public function __construct(){
        parent::__construct();
    }

    /**
     * Called by flow asynchronously in order to confirm the payment 
     *
     * @return void
     */
    public function postProcess(){

        try{

            if(!Tools::getIsset('token')){
                throw new \Exception('Token is missing');
            }

            Logger::addLog('Entering the confirmation callback');
            Logger::addLog('Invoking the confirmation endpoint with params: '.json_encode($_POST));

            $service = 'payment/getStatus';
            $params = array(
                'token' =>  Tools::getValue('token'),
            );
            $method = 'GET';
            $apiKey = Configuration::get('FLOW_WP_API_KEY');
            $secretKey = Configuration::get('FLOW_WP_SECRET_KEY');
            $mode = Configuration::get('FLOW_WP_MODE');
            $endpoint = $mode == 'TEST' ? 'https://sandbox.flow.cl/api' : 'https://www.flow.cl/api';
            
            $flowApi = new FlowApiWP($apiKey, $secretKey, $endpoint);
            Logger::addLog('Calling Flow Service: '.$service." with params: ".json_encode($params));
            $result = $flowApi->send($service, $params, $method);
            Logger::addLog('Flow response: '.json_encode($result));

            $commerceOrder = $result['commerceOrder'];

            $order = new Order((int)$commerceOrder);
            if($order->id === null){
                throw new Exception('The order does not exist.');
            }
            
            $cart = new Cart(Cart::getCartIdByOrderId($order->id));

            $currency = $this->context->currency;
            $customer = new Customer($cart->id_customer);

            $statusInFlow = $result['status'];
            $flowAmount = (int)$result['amount'];
            $amount = (int) $cart->getOrderTotal(true, Cart::BOTH);
            $rechargePercentage = Configuration::get('FLOW_WP_RECHARGE');
            $recharge = round(($amount * $rechargePercentage) /100.0 );
            $finalAmount = (int) ($amount + $recharge);

            if($finalAmount != $flowAmount){
                throw new Exception('The amount has been altered. Aborting...');
            }
                
            /*if($this->isTesting($result)){
                $this->setProductionEnvSimulation($statusInFlow, $result);
            }*/

            if($this->isPendingInFlow($statusInFlow)){
                Logger::addLog('Setting order as pending...');
                $orderStatus = Configuration::get('FLOW_PAYMENT_PENDING');
            }
            elseif($this->isPaidInFlow($statusInFlow)){

                Logger::addLog('Setting the order as paid');
                $orderStatus = Configuration::get('PS_OS_PAYMENT');
            }
            elseif($this->isCancelledInFlow($statusInFlow)){
                Logger::addLog('Setting order as canceled...');
                $orderStatus = Configuration::get('PS_OS_CANCELED');
            }
            else{
                Logger::addLog('Setting order as rejected...');
                $orderStatus = Configuration::get('PS_OS_ERROR');
            }

            
            if($order->getCurrentState() == Configuration::get('FLOW_PAYMENT_PENDING')){
                
                if($orderStatus !== Configuration::get('FLOW_PAYMENT_PENDING')){                    
                    Logger::addLog('Changing the order status');
                    $order->setCurrentstate($orderStatus);
                }
            }
            
        }catch(\Exception $e){
            Logger::addLog('There has been an unexpected error: '.$e->getCode(). ' - '.$e->getMessage());
        }
    }

    private function isPendingInFlow($status){
        return $status == 1;
    }

    private function isPaidInFlow($status){
        return $status == 2;
    }

    private function isRejectedInFlow($status){
        return $status == 3;
    }

    private function isCancelledInFlow($status){
        return $status == 4;
    }

    private function isTesting($flowPaymentData){

        return Configuration::get('FLOW_WP_MODE') == 'TEST' && ($flowPaymentData['paymentData']['media'] == 'Multicaja' || $flowPaymentData['paymentData']['media'] == 'Servipag');
    }

    private function setProductionEnvSimulation(&$status, &$flowPaymentData){
        $status = 1;
    }
}