<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Video con Chat y Reacciones</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        /* Estilos generales */
        body {
            background-color: #000;
            color: #fff;
            font-family: Arial, sans-serif;
            text-align: center;
            margin: 0;
            padding: 0;
        }

        /* Contenedor del video */
        #video-container {
            position: relative;
            width: 90%;
            max-width: 800px;
            margin: 0 auto;
            aspect-ratio: 16 / 9;
            background-color: #000;
        }

        /* Estilo para el video */
        #video {
            width: 100%;
            height: auto;
        }

        /* Estilo para los mensajes que aparecerán sobre el video */
        #mensaje-sobre-video {
            position: absolute;
            bottom: 10%;
            left: 50%;
            transform: translateX(-50%);
            background-color: rgba(0, 0, 0, 0.7);
            color: white;
            padding: 5px 10px;
            border-radius: 5px;
            display: none;
            font-size: 18px;
            animation: desvanecer 5s forwards;
        }

        /* Animación para desvanecer los mensajes */
        @keyframes desvanecer {
            0% { opacity: 1; }
            100% { opacity: 0; }
        }

        /* Estilo para los botones de reacciones */
        #reacciones {
            margin-top: 10px;
            margin-bottom: 10px;
            display: flex;
            justify-content: center;
            gap: 10px;
        }

        .reaccion-boton {
            padding: 10px 20px;
            background-color: #007BFF;
            color: #fff;
            border: none;
            border-radius: 50px;
            cursor: pointer;
            font-size: 16px;
        }

        /* Contenedor del chat */
        #chat-container {
            width: 90%;
            max-width: 400px;
            margin: 20px auto;
            text-align: center;
        }

        /* Campos de entrada */
        #nombre-usuario, #mensaje-chat {
            width: 45%; /* Ajusta para que no llenen toda la pantalla */
            padding: 10px;
            border: 2px solid #007BFF;
            border-radius: 5px;
            margin: 5px 2.5%;
            background-color: #000;
            color: #fff;
            box-sizing: border-box; /* Asegura que el padding no afecte el ancho */
        }

        #enviar-mensaje-btn {
            width: 50%; /* Ajusta el ancho para que sea más pequeño */
            padding: 10px;
            background-color: #007BFF;
            color: #fff;
            border: none;
            border-radius: 50px;
            cursor: pointer;
            font-size: 16px;
            margin-top: 10px;
            display: block;
            margin-left: auto;
            margin-right: auto; /* Centra el botón */
        }

        /* Animaciones de reacciones */
        .animacion-reaccion {
            position: absolute;
            left: 50%;
            transform: translateX(-50%);
            animation: explotar 1.5s ease-out forwards;
            font-size: 20px;
            color: #ff4081;
        }

        @keyframes explotar {
            0% { bottom: 0%; opacity: 1; transform: translateX(-50%) scale(1); }
            50% { bottom: 50%; opacity: 1; transform: translateX(-50%) scale(1.5); }
            100% { bottom: 80%; opacity: 0; transform: translateX(-50%) scale(2); }
        }

        /* Ajustes de estilo para dispositivos móviles */
        @media (max-width: 600px) {
            .reaccion-boton {
                font-size: 14px;
                padding: 8px 16px;
            }

            #nombre-usuario, #mensaje-chat {
                width: 45%; /* Mantener el ajuste para móviles */
            }

            #enviar-mensaje-btn {
                width: 70%; /* Ajustar ancho en móviles */
            }
        }
    </style>
</head>
<body>

<div id="video-container">
    <!-- Video que se expandirá según el tamaño de la pantalla -->
    <video id="video" src="https://vdochile.com:3313/stream/play.m3u8" controls></video>

    <!-- Div para mostrar mensajes sobre el video -->
    <div id="mensaje-sobre-video"></div>

    <!-- Animaciones de reacciones se generan aquí -->
    <div id="animacion-reacciones-container"></div>
</div>

<!-- Sección de botones de reacciones debajo del video -->
<div id="reacciones">
    <button class="reaccion-boton" onclick="enviarReaccion('Me Gusta')">Me Gusta</button>
    <button class="reaccion-boton" onclick="enviarReaccion('Me Encanta')">Me Encanta</button>
    <button class="reaccion-boton" onclick="enviarReaccion('No Me Gusta')">No Me Gusta</button>
</div>

<!-- Contenedor del chat -->
<div id="chat-container">
    <input type="text" id="nombre-usuario" placeholder="Tu Nombre">
    <input type="text" id="mensaje-chat" placeholder="Escribe tu mensaje">
    <button id="enviar-mensaje-btn" onclick="enviarMensaje()">Enviar</button>
</div>

<script>
    // Inicialización del WebSocket
    const socket = new WebSocket('ws://tutv.cl:8080'); // Cambia 'localhost' por tu dominio si no estás en local

    socket.onopen = function() {
        console.log("Conectado al servidor WebSocket");
    };

    socket.onmessage = function(event) {
        const data = JSON.parse(event.data);

        if (data.tipo === 'mensaje') {
            mostrarMensajeSobreVideo(data.contenido);
        } else if (data.tipo === 'reaccion') {
            mostrarAnimacionReaccion(data.simbolo, data.mensaje);
        }
    };

    socket.onclose = function() {
        console.log("Desconectado del servidor WebSocket");
    };

    // Función para manejar las reacciones
    function enviarReaccion(tipoReaccion) {
        let simbolo = '';
        let mensaje = '';

        switch (tipoReaccion) {
            case 'Me Gusta':
                simbolo = '❤️';
                mensaje = 'Me Gusta';
                break;
            case 'Me Encanta':
                simbolo = '😍';
                mensaje = 'Me Encanta';
                break;
            case 'No Me Gusta':
                simbolo = '👎';
                mensaje = 'No Me Gusta';
                break;
        }

        mostrarAnimacionReaccion(simbolo, mensaje);

        // Enviar la reacción al servidor WebSocket
        socket.send(JSON.stringify({ tipo: 'reaccion', simbolo: simbolo, mensaje: mensaje }));
    }

    // Función para enviar mensajes de chat
    function enviarMensaje() {
        const nombre = document.getElementById('nombre-usuario').value;
        const mensaje = document.getElementById('mensaje-chat').value;

        if (nombre && mensaje) {
            const mensajeCompleto = `${nombre} ha dicho: ${mensaje}`;
            mostrarMensajeSobreVideo(mensajeCompleto);

            // Enviar el mensaje al servidor WebSocket
            socket.send(JSON.stringify({ tipo: 'mensaje', contenido: mensajeCompleto }));

            document.getElementById('mensaje-chat').value = '';
        }
    }

    // Función para mostrar mensajes sobre el video
    function mostrarMensajeSobreVideo(mensaje) {
        const mensajeDiv = document.getElementById('mensaje-sobre-video');
        mensajeDiv.textContent = mensaje;
        mensajeDiv.style.display = 'block';
        setTimeout(() => {
            mensajeDiv.style.display = 'none';
        }, 5000); // El mensaje desaparecerá después de 5 segundos
    }

    // Función para mostrar animaciones de reacciones
    function mostrarAnimacionReaccion(simbolo, mensaje) {
        const animacionDiv = document.createElement('div');
        animacionDiv.classList.add('animacion-reaccion');
        animacionDiv.textContent = simbolo + ' ' + mensaje;

        document.getElementById('animacion-reacciones-container').appendChild(animacionDiv);

        setTimeout(() => {
            animacionDiv.remove();
        }, 1500); // La animación desaparecerá después de 1.5 segundos
    }

    // Permitir enviar mensaje al presionar Enter
    document.getElementById('mensaje-chat').addEventListener('keypress', function(event) {
        if (event.key === 'Enter') {
            enviarMensaje();
        }
    });
</script>

</body>
</html>
