<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Enviar Mensaje</title>
    <style>
        body {
            background-color: #F9F9F9;
            font-family: Arial, sans-serif;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            margin: 0;
        }
        .container {
            background-color: white;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0,0,0,0.1);
            width: 80%;
            max-width: 600px;
        }
        textarea {
            width: 100%;
            height: 500px; /* Ajustado para un campo de texto más grande */
        }
        input[type="submit"] {
            background-color: #4CAF50; /* Verde */
            border: none;
            color: white;
            padding: 15px 32px;
            text-align: center;
            text-decoration: none;
            display: inline-block;
            font-size: 16px;
            margin: 4px 2px;
            cursor: pointer;
        }
    </style>
    <script src="https://cdn.tiny.cloud/1/y7o7xdfaq3c90rmbzytbkirfu1wbqhzbnx8qv73whduab1xp/tinymce/5/tinymce.min.js" referrerpolicy="origin"></script>
    <script>
        tinymce.init({
            selector: '#mensaje',
            plugins: 'advlist autolink lists link image charmap print preview hr anchor pagebreak',
            toolbar_mode: 'floating',
        });
    </script>
</head>
<body>
    <div class="container">
        <h1>Enviar Mensaje</h1>
        <form action="send_email.php" method="POST">
            <label for="destino">Enviar a:</label>
            <select name="destino" id="destino">
                <option value="todos">Todos los Usuarios</option>
                <?php
                $conn = new mysqli('localhost', 'anet_ve', 'reserva2020', 'anet_ve');
                if ($conn->connect_error) {
                    die("Connection failed: " . $conn->connect_error);
                }
                $conn->set_charset("utf8mb4");

                $query = "SELECT nombre, correo FROM registros";
                $result = $conn->query($query);

                if ($result->num_rows > 0) {
                    while ($row = $result->fetch_assoc()) {
                        echo "<option value='" . htmlspecialchars($row['correo']) . "'>" . htmlspecialchars($row['nombre']) . "</option>";
                    }
                }

                $conn->close();
                ?>
            </select>
            <br><br>
            <textarea id="mensaje" name="mensaje"></textarea>
            <br>
            <input type="submit" value="Enviar Mensaje">
        </form>
    </div>
</body>
</html>

