<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Panel de Administración</title>
    <style>
        body {
            background-color: #F9F9F9;
            font-family: Arial, sans-serif;
        }
        .container {
            width: 80%;
            margin: 20px auto;
            background-color: white;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0,0,0,0.1);
        }
        h1 {
            text-align: center;
        }
        table {
            width: 90%;
            margin: 20px auto;
            border-collapse: collapse;
        }
        th, td {
            padding: 8px;
            text-align: left;
            border-bottom: 1px solid #ddd;
        }
        th {
            background-color: #f2f2f2;
        }
        .delete-btn {
            background-color: #f44336; /* Red color */
            color: white;
            border: none;
            padding: 5px 10px;
            cursor: pointer;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>Registro de Usuarios</h1>
        <table>
            <tr>
                <th>Nombre</th>
                <th>Rut</th>
                <th>Correo</th>
                <th>Fono</th>
                <th>Dirección</th>
                <th>Ciudad</th>
                <th>Profesión</th>
                <th>Acciones</th>
            </tr>
            <?php
            $host = 'localhost';
            $dbUsername = 'anet_ve';
            $dbPassword = 'reserva2020';
            $dbName = 'anet_ve';

            $conn = new mysqli($host, $dbUsername, $dbPassword, $dbName);
            $conn->set_charset("utf8");

            if ($conn->connect_error) {
                die("Connection failed: " . $conn->connect_error);
            }

            $sql = "SELECT nombre, rut, correo, fono, direccion, ciudad, rol FROM registros";
            $result = $conn->query($sql);

            if ($result->num_rows > 0) {
                while($row = $result->fetch_assoc()) {
                    echo "<tr>
                        <td>" . htmlspecialchars($row['nombre']) . "</td>
                        <td>" . htmlspecialchars($row['rut']) . "</td>
                        <td>" . htmlspecialchars($row['correo']) . "</td>
                        <td>" . htmlspecialchars($row['fono']) . "</td>
                        <td>" . htmlspecialchars($row['direccion']) . "</td>
                        <td>" . htmlspecialchars($row['ciudad']) . "</td>
                        <td>" . htmlspecialchars($row['rol']) . "</td>
                        <td>
                            <form action='delete_user.php' method='post'>
                                <input type='hidden' name='rut' value='" . $row['rut'] . "'>
                                <button type='submit' class='delete-btn'>Eliminar</button>
                            </form>
                        </td>
                    </tr>";
                }
            } else {
                echo "<tr><td colspan='8'>No hay registros para mostrar</td></tr>";
            }
            $conn->close();
            ?>
        </table>
    </div>
</body>
</html>
