<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Formulario de Registro</title>
    <style>
        body {
            background-color: #F9F9F9;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            margin: 0;
            font-family: Arial, sans-serif;
        }
        form {
            background-color: white;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0,0,0,0.1);
            width: 90%;
            font-size: 16px; /* Tamaño de fuente aumentado */
        }
        form input[type="text"], form input[type="email"], form input[type="radio"] {
            padding: 8px;
            margin: 6px 0;
            box-sizing: border-box;
            border: 1px solid #ccc;
            border-radius: 4px;
            font-size: 16px; /* Tamaño de fuente aumentado para inputs y labels */
        }
        form input[type="text"], form input[type="email"] {
            width: 100%;
        }
        .checkbox-group {
            display: flex;
            align-items: center;
        }
        .checkbox-group label {
            margin: 0 8px 0 4px;
            font-size: 16px;
        }
        button {
            background-color: #1474E1; /* Light Steel Blue para un azul piedra claro */
            color: white;
            padding: 12px 24px; /* Aumentar padding para un botón más grande */
            border: none;
            border-radius: 4px;
            cursor: pointer;
            width: 100%;
            margin-top: 20px; /* Espacio adicional sobre el botón */
        }
        button:hover {
            background-color: #74B5FF; /* Un tono ligeramente más oscuro para el hover */
        }
        .error {
            color: red;
            font-weight: bold;
            text-align: center;
            margin-top: 10px;
        }
    </style>
    <script>
    function validarRUT(rut) {
        var valor = rut.replace(/\./g, '').replace(/-/g, '');
        var cuerpo = valor.slice(0, -1);
        var dv = valor.slice(-1).toUpperCase();

        if (cuerpo.length < 7) {
            mostrarError('El RUT ingresado es demasiado corto.');
            return false;
        }

        var suma = 0;
        var multiplo = 2;

        for (var i = 1; i <= cuerpo.length; i++) {
            var index = multiplo * parseInt(cuerpo.charAt(cuerpo.length - i), 10);
            suma += index;
            multiplo = (multiplo < 7) ? multiplo + 1 : 2;
        }

        var dvEsperado = 11 - (suma % 11);
        dvEsperado = (dvEsperado === 10) ? 'K' : (dvEsperado === 11) ? '0' : dvEsperado.toString();

        if (dv !== dvEsperado) {
            mostrarError('El RUT ingresado no es válido.');
            return false;
        }
        limpiarErrores();
        return true;
    }

    function mostrarError(mensaje) {
        var errorDiv = document.querySelector('.error');
        errorDiv.textContent = mensaje;
    }

    function limpiarErrores() {
        var errorDiv = document.querySelector('.error');
        errorDiv.textContent = '';
    }

    document.addEventListener('DOMContentLoaded', function () {
        document.querySelector('form').onsubmit = function(e) {
            var rut = document.getElementById('rut').value;
            if (!validarRUT(rut)) {
                e.preventDefault();
            }
        };
    });
    </script>
</head>
<body>
    <form action="registrar.php" method="POST">
        <input type="text" id="nombre" name="nombre" required placeholder="Nombre"><br>
        <input type="text" id="rut" name="rut" required placeholder="Rut sin puntos ni guión"><br>
        <input type="email" id="correo" name="correo" required placeholder="Correo Electrónico"><br>
        <input type="text" id="fono" name="fono" required placeholder="Fono"><br>
        <input type="text" id="direccion" name="direccion" required placeholder="Dirección"><br>
        <input type="text" id="ciudad" name="ciudad" required placeholder="Ciudad"><br>
        <input type="text" id="local" name="local" required placeholder="Ingrese su local"><br>

        <div class="checkbox-group">
            <input type="radio" id="quimico" name="rol" value="Químico Farmacéutico">
            <label for="quimico">Químico Farmacéutico</label>
        </div>
        <div class="checkbox-group">
            <input type="radio" id="auxiliar" name="rol" value="Auxiliar de Farmacia">
            <label for="auxiliar">Auxiliar de Farmacia</label>
        </div>

        <button type="submit">Registrarse</button>
        <div class="error"></div>
    </form>
    <script>
document.getElementById('rut').addEventListener('input', function (event) {
    var value = this.value.replace(/[^0-9kK]/g, ''); // Elimina todo lo que no sean dígitos o 'K' (mayúscula o minúscula)
    this.value = value.toUpperCase(); // Actualiza el valor del campo y convierte todo a mayúsculas
});
</script>
</body>
</html>
