<?php
require '/home/anet/vendor/autoload.php';

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

// Configuración de la conexión a la base de datos
$host = 'localhost';
$dbUsername = 'anet_re';
$dbPassword = 'reserva2020';
$dbName = 'anet_re';

$conn = new mysqli($host, $dbUsername, $dbPassword, $dbName);
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}
$conn->set_charset("utf8");

// Crear nuevo documento
$spreadsheet = new Spreadsheet();
$sheet = $spreadsheet->getActiveSheet();

// Establecer encabezados de columna
$sheet->setCellValue('A1', 'Nombre');
$sheet->setCellValue('B1', 'Correo');
$sheet->setCellValue('C1', 'Ciudad');
$sheet->setCellValue('D1', 'Local');
$sheet->setCellValue('E1', 'Ingresos');

// Recuperar y escribir datos
$query = "SELECT r.nombre, r.correo, r.ciudad, r.local, COUNT(a.id) AS ingresos
          FROM registros r
          LEFT JOIN asistencias a ON r.correo = a.correo
          GROUP BY r.nombre, r.correo, r.ciudad, r.local";
$result = $conn->query($query);
$rowNum = 2;
while ($row = $result->fetch_assoc()) {
    $sheet->setCellValue('A' . $rowNum, $row['nombre']);
    $sheet->setCellValue('B' . $rowNum, $row['correo']);
    $sheet->setCellValue('C' . $rowNum, $row['ciudad']);
    $sheet->setCellValue('D' . $rowNum, $row['local']);
    $sheet->setCellValue('E' . $rowNum, $row['ingresos']);
    $rowNum++;
}

$writer = new Xlsx($spreadsheet);

// Establecer cabeceras para descargar el archivo Excel
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment;filename="Asistencia_Usuarios.xlsx"');
header('Cache-Control: max-age=0');

$writer->save('php://output');
exit;
?>
