<?php

use Thrive\Automator\Items\Trigger_Field;

class HappyForms_Thrive_Automator_Trigger_Email_Field extends Trigger_Field {

	public static function get_id(): string {
		return 'happyforms/trigger_email_field';
	}

	public static function get_name(): string {
		return 'Email field';
	}

	public static function get_description(): string {
		return 'The field providing the user\'s email address';
	}

	public static function get_placeholder(): string {
		return 'Email field';
	}

	public static function get_type(): string {
		return Thrive\Automator\Utils::FIELD_TYPE_SELECT;
	}

	public static function is_ajax_field(): bool {
		return true;
	}

	public static function get_options_callback( $trigger_id, $trigger_data ): array {
		$form_field = HappyForms_Thrive_Automator_Trigger_Form_Field::get_id();
		$form_field = (array) $trigger_data->$form_field;
		$fields = [];

		if ( isset( $form_field['value'] ) ) {
			$form_id = $form_field['value'];
			$form = happyforms_get_form_controller()->get( $form_id );
			$fields = array_filter( $form['parts'], function( $part ) {
				return 'email' === $part['type'];
			} );

			$fields = array_map( function( $part ) {
				$label = (
					! empty ( $part['label'] ) ?
					$part['label'] :
					__( 'Unlabeled field', 'happyforms' )
				);
				
				return [
					'id' => $part['id'],
					'label' => $label,
				];
			}, $fields );
		}
		
		return $fields;
	}

	public static function get_dummy_value() {
		return 'happyforms-email-field';
	}

}