<?php

use Thrive\Automator\Items\Data_Object;
use Thrive\Automator\Utils;

class HappyForms_Thrive_Automator_Data_Object extends Data_Object {

	public static function get_id(): string {
		return 'happyforms/submission';
	}

	public static function get_nice_name() {
		return __( 'Happyforms form data', 'happyforms' );
	}

	public static function get_fields(): array {
		return [];
	}

	public static function create_object( $submission_fields ): array {
		$data = $submission_fields;

	    return $data;
	}

	public function replace_dynamic_data( $value ) {
		$value = parent::replace_dynamic_data( $value );
		$value = Utils::replace_additional_data_shortcodes( $value, $this->data );

		return $value;
	}

}