<?php

class HappyForms_Service_PayPal extends HappyForms_Service {

	public $id = 'paypal';
	public $group = 'payments';

	public function __construct() {
		$this->label = __( 'PayPal', 'happyforms' );
	}

	public function set_credentials( $credentials = array(), $raw = array() ) {
		$this->credentials = array(
			'enabled' => '',
			'client_id' => '',
			'client_secret' => '',
			'sandbox_client_id' => '',
			'sandbox_client_secret' => '',
			'mode' => 'live',
		);

		foreach ( $this->credentials as $key => $value ) {
			if ( isset( $credentials[$key] ) && '' !== $credentials[$key] ) {
				$this->credentials[$key] = $credentials[$key];
			}
		}

		if ( ! empty( $raw ) ) {
			$this->credentials['enabled']      = ( isset( $raw['enabled'] ) ) ? 1 : 0;
		}
	}

	public function is_connected() {
		$mode = $this->credentials['mode'];
		$authenticated = false;

		if ( 'live' === $mode ) {
			$authenticated = ! ( empty( $this->credentials['client_id'] ) || empty( $this->credentials['client_secret'] ) );
		} else {
			$authenticated = ! ( empty( $this->credentials['sandbox_client_id'] ) || empty( $this->credentials['sandbox_client_secret'] ) );
		}

		return $authenticated;
	}

	public function admin_widget( $previous_credentials = array() ) {
		require_once( happyforms_get_integrations_folder() . '/services/paypal/partial-widget.php' );
	}

	public function configure() {
		$this->load();
	}

	public function load() {
		require_once( happyforms_get_integrations_folder() . '/services/paypal/class-integration-paypal.php' );
	}

}
