<script type="text/template" id="happyforms-customize-payments-template">
	<?php
	$integrations = happyforms_get_integrations();
	$paypal = $integrations->get_service( 'paypal' );
	$stripe = $integrations->get_service( 'stripe' );
	?>

	<?php include( happyforms_get_core_folder() . '/templates/customize-form-part-header.php' ); ?>

	<?php do_action( 'happyforms_part_customize_payments_before_options' ); ?>

	<p class="label-field-group">
		<label for="<%= instance.id %>_title"><?php _e( 'Label', 'happyforms' ); ?></label>
		<div class="label-group">
			<input type="text" id="<%= instance.id %>_title" class="widefat title" value="<%- instance.label %>" data-bind="label" />
			<div class="happyforms-buttongroup">
				<label for="<%= instance.id %>-label_placement-show">
					<input type="radio" id="<%= instance.id %>-label_placement-show" value="show" name="<%= instance.id %>-label_placement" data-bind="label_placement" <%= ( instance.label_placement == 'show' ) ? 'checked' : '' %> />
					<span><?php _e( 'Show', 'happyforms' ); ?></span>
				</label>
				<label for="<%= instance.id %>-label_placement-hidden">
					<input type="radio" id="<%= instance.id %>-label_placement-hidden" value="hidden" name="<%= instance.id %>-label_placement" data-bind="label_placement" <%= ( instance.label_placement == 'hidden' ) ? 'checked' : '' %> />
					<span><?php _e( 'Hide', 'happyforms' ); ?></span>
				</label>
 			</div>
		</div>
	</p>
	<p>
		<label for="<%= instance.id %>_description"><?php _e( 'Hint', 'happyforms' ); ?></label>
		<textarea id="<%= instance.id %>_description" data-bind="description"><%= instance.description %></textarea>
	</p>

	<p>
		<label for="<%= instance.id %>_currency"><?php _e( 'Currency', 'happyforms' ); ?></label>
		<select id="<%= instance.id %>_currency" data-bind="currency" class="widefat">
		<?php
		$currencies = happyforms_payment_get_currencies( 'stripe' );

		foreach( $currencies as $currency_key => $currency_data ) : ?>
			<option value="<?php echo $currency_key; ?>"<%= (instance.currency == '<?php echo $currency_key; ?>') ? ' selected' : '' %>><?php echo $currency_data['label']; ?></option>
		<?php endforeach; ?>
		</select>
	</p>

	<p class="price-field" style="display: <%= ( instance.show_user_price_field ) ? 'none' : 'block' %>">
		<label for="<%= instance.id %>_price"><?php _e( 'Price', 'happyforms' ); ?></label>
		<input type="number" min="0" id="<%= instance.id %>_price" class="widefat title" value="<%= instance.price %>" data-bind="price" />
	</p>

	<div class="happyforms-part-settings-logic-view" data-logic-type="set" data-logic-id="price" data-logic-then-text="<?php _e( 'Then price is…', 'happyforms' ); ?>" style="display: <%= ( instance.show_user_price_field ) ? 'none' : 'block' %>">
		<?php happyforms_customize_part_logic(); ?>
	</div>

	<?php do_action( 'happyforms_part_customize_payments_after_options' ); ?>

	<?php do_action( 'happyforms_part_customize_payments_before_advanced_options' ); ?>

	<p>
		<label>
			<input type="checkbox" class="checkbox" value="1" <% if ( instance.show_user_price_field ) { %>checked="checked"<% } %> data-bind="show_user_price_field" /> <?php _e( 'Use \'pay what you want\' pricing', 'happyforms' ); ?>
		</label>
	</p>

	<div class="happyforms-nested-settings" data-trigger="show_user_price_field" style="display: <%= ( 1 == instance.show_user_price_field ) ? 'block' : 'none' %>">
		<p>
			<label for="<%= instance.id %>_user_price_min"><?php _e( 'Minimum accepted amount', 'happyforms' ); ?></label>
			<input type="number" id="<%= instance.id %>_user_price_min" class="widefat title" value="<%= instance.user_price_min %>" min="0" data-bind="user_price_min" />
		</p>
		<p>
			<label for="<%= instance.id %>_user_price_placeholder"><?php _e( 'Placeholder', 'happyforms' ); ?></label>
			<input type="text" id="<%= instance.id %>_user_price_placeholder" class="widefat title" value="<%- instance.user_price_placeholder %>" data-bind="user_price_placeholder" />
		</p>
		<p>
			<label for="<%= instance.id %>_user_price_step"><?php _e( 'Step Interval', 'happyforms' ); ?></label>
			<input type="number" id="<%= instance.id %>_user_price_step" class="widefat title" value="<%= instance.user_price_step %>" data-bind="user_price_step" />
		</p>
	</div>
	<p>
		<label>
			<input type="checkbox" class="checkbox" value="1" <% if ( instance.accept_coupons ) { %>checked="checked"<% } %> data-bind="accept_coupons" /> <?php _e( 'Accept coupons', 'happyforms' ); ?>
		</label>
	</p>
	<p>
		<label>
			<input type="checkbox" class="checkbox" value="1" <% if ( instance.required ) { %>checked="checked"<% } %> data-bind="required" /> <?php _e( 'Require an answer', 'happyforms' ); ?>
		</label>
	</p>
	<p class="happyforms-buttongroup-wrapper">
		<label for="<%= instance.id %>_width"><?php _e( 'Width', 'happyforms' ); ?></label>
		<span class="happyforms-buttongroup happyforms-buttongroup-field_width">
			<label for="<%= instance.id %>_width_full">
				<input type="radio" id="<%= instance.id %>_width_full" value="full" name="<%= instance.id %>_width" data-bind="width" <%= ( instance.width == 'full' ) ? 'checked' : '' %> />
				<span><?php _e( 'Full', 'happyforms' ); ?></span>
			</label>

			<label for="<%= instance.id %>_width_half">
				<input type="radio" id="<%= instance.id %>_width_half" value="half" name="<%= instance.id %>_width" data-bind="width" <%= ( instance.width == 'half' ) ? 'checked' : '' %> />
				<span><?php _e( 'Half', 'happyforms' ); ?></span>
			</label>

			<label for="<%= instance.id %>_width_third">
				<input type="radio" id="<%= instance.id %>_width_third" value="third" name="<%= instance.id %>_width" data-bind="width" <%= ( instance.width == 'third' ) ? 'checked' : '' %>/>
				<span><?php _e( 'Third', 'happyforms' ); ?></span>
			</label>
			<label for="<%= instance.id %>_width_quarter">
				<input type="radio" id="<%= instance.id %>_width_quarter" value="quarter" data-bind="width" name="<%= instance.id %>_width" <%= ( instance.width == 'quarter' ) ? 'checked' : '' %>/>
				<span><?php _e( 'Quarter', 'happyforms' ); ?></span>
			</label>

			<label for="<%= instance.id %>_width_auto">
				<input type="radio" id="<%= instance.id %>_width_auto" value="auto" data-bind="width" name="<%= instance.id %>_width" <%= ( instance.width == 'auto' ) ? 'checked' : '' %> />
				<span><?php _e( 'Auto', 'happyforms' ); ?></span>
			</label>
		</span>
	</p>
	<p class="width-options" style="display: none">
		<label>
			<input type="checkbox" class="checkbox apply-all-check" value="" data-apply-to="width" /> <?php _e( 'Apply to all fields', 'happyforms' ); ?>
		</label>
	</p>

	<?php do_action( 'happyforms_part_customize_payments_after_advanced_options' ); ?>

	<p>
		<label for="<%= instance.id %>_css_class"><?php _e( 'Additional CSS class(es)', 'happyforms' ); ?></label>
		<input type="text" id="<%= instance.id %>_css_class" class="widefat title" value="<%- instance.css_class %>" data-bind="css_class" />
	</p>

	<div class="happyforms-part-logic-wrap">
		<div class="happyforms-logic-view">
			<?php happyforms_customize_part_logic(); ?>
		</div>
	</div>

	<div class="happyforms-widget-actions">
		<a href="#" class="happyforms-form-part-remove"><?php _e( 'Delete', 'happyforms' ); ?></a>
		<a href="#" class="happyforms-form-part-logic"><?php _e( 'Logic', 'happyforms' ); ?></a>
	</div>
</script>
