<?php

class HappyForms_Service_Google_Analytics4 extends HappyForms_Service {

	public $id = 'google-analytics4';
	public $group = 'analytics';

	private $endpoint = 'https://www.google-analytics.com/mp/collect?api_secret=%s&measurement_id=%s';

	const EVENT_VIEW = 'view';
	const EVENT_SUCCESS = 'success';
	const EVENT_ERROR = 'error';
	const EVENT_ABANDON = 'abandoned';
	const EVENT_RESUME = 'resume';

	public function __construct() {
		$this->label = __( 'Google Analytics 4', 'happyforms' );
	}

	public function get_default_credentials() {
		$credentials = array(
			'enabled' => '',
			'tracking_id' => '',
			'api_secret' => '',
		);

		return $credentials;
	}

	public function set_credentials( $credentials = array(), $raw = array() ) {
		$this->credentials = wp_parse_args( $credentials, $this->get_default_credentials() );

		if ( ! empty( $raw ) ) {
			$this->credentials['enabled'] = ( isset( $raw['enabled'] ) ) ? 1 : 0;
		}
	}

	public function is_connected() {
		$is_connected = ! empty( $this->credentials['tracking_id'] );

		return $is_connected;
	}

	public function admin_widget( $previous_credentials = array() ) {
		require_once( happyforms_get_integrations_folder() . '/services/google-analytics4/partial-widget.php' );
	}

	public function configure() {
		$this->load();
	}

	public function load() {
		if ( $this->is_connected() ) {
			require_once( happyforms_get_integrations_folder() . '/services/google-analytics4/class-integration-google-analytics.php' );
		}
	}

	public function get_default_meta() {
		$meta = array(
			'session_id' => '',
			'user_agent' => '',
			'page_url' => '',
			'referer' => '',
		);

		return $meta;
	}

	public function get_utm_meta() {
		$meta = array(
			'utm_campaign' => 'cn',
			'utm_source' => 'cs',
			'utm_medium' => 'cm',
			'utm_term' => 'ck',
			'utm_content' => 'cc',
		);

		return $meta;
	}

	public function make_request( $body ) {
		$endpoint = sprintf( $this->endpoint, $this->credentials['api_secret'], $this->credentials['tracking_id'] );

		$response = wp_remote_post( $endpoint, array(
			'headers' => array(
		        'Content-Type' => 'application/json'
		    ),
			'body' => json_encode( $body ),
			 'method' => 'POST',
       		'data_format' => 'body',
		) );

		return $response;
	}

	public function track_event( $form, $event, $meta, $utm = array() ) {
		$form_title = happyforms_get_form_title( $form );
		$meta = wp_parse_args( $meta, $this->get_default_meta() );

		$params = array (
			'form_title' => $form_title,
			'uip' => happyforms_get_client_ip(),
			'user_agent' => $meta['user_agent'],
			'page_url' => $meta['referer'],
			'referer' => $meta['page_url'],
		);
		$utm = array_filter( $utm );
		$params = array_merge( $params, $utm );

		$event = array(
			'name' => 'Happyforms_' . $event,
			'params' => $params,
		);

		$body = array(
			'client_id' => $meta['session_id'],
			'events' => array( $event ),
		);

		$response = $this->make_request( $body );
	}

}
